/* key_filter.h */
#ifndef __KEY_FILTER_H__
#define __KEY_FILTER_H__

#include <stdint.h>
#include <stdbool.h>
#include <string.h>

/* Keep all the static variable and information for each key. */
typedef struct
{
    /* Attr. */
    uint32_t FilterCountMax; /* The output would change if the new value keeps enough time. */

    /* Static. */
    uint32_t InitValue; /* Initialize value. Actually only available for Asymmetric Filter. */
    uint32_t CurStableValue; /* Current output value. */
    uint32_t NewValue; /* Protential output value, would be change to output value if it keeps long enough. */
    uint32_t AccCounterForNewValue; /* Tick counter for nex value. */
} Key_FilterHandler_T;

void Key_Filter_Init(Key_FilterHandler_T *handler, uint32_t initValue, uint32_t filterCount);

uint32_t Key_Filter_GetSymmetricDebounceOutput(Key_FilterHandler_T *handler, uint32_t curUnfiltedValue);
uint32_t Key_Filter_GetAsymmetricDebounceOutput(Key_FilterHandler_T *handler, uint32_t curUnfiltedValue);


#endif /* __KEY_FILTER_H__ */

