/* key_filter.c */
#include "key_filter.h"

void Key_Filter_Init(Key_FilterHandler_T *handler, uint32_t initValue, uint32_t filterCount)
{
    /* For Attr. */
    handler->FilterCountMax = filterCount-1U;

    /* For Static. */
    handler->InitValue = initValue;
    handler->CurStableValue = initValue;
    handler->NewValue = initValue;
    handler->AccCounterForNewValue = 1U;
}


uint32_t Key_Filter_GetSymmetricDebounceOutput(Key_FilterHandler_T *handler, uint32_t curUnfiltedValue)
{
    /* 如果滤波器的输入值同当前输出值相等，则各内部状态机相安无事，直接输出。否则，开始准备更新内部状态 */
    if (curUnfiltedValue != handler->CurStableValue)
    {
        if (curUnfiltedValue != handler->NewValue)
        {
            handler->NewValue = curUnfiltedValue;
            handler->AccCounterForNewValue = 1U; /* 计数器开始计数 */
        }
        else /* curUnfiltedValue == handler->NewValue */
        {
            if (handler->AccCounterForNewValue < handler->FilterCountMax)
            {
                handler->AccCounterForNewValue++; /* 积攒能量准备突破 */
            }
            else /* (handler->AccCounterForNewValue >= handler->FilterCountMax) */
            {
                handler->CurStableValue = handler->NewValue; /* 成功突破封锁线 */
            }
        }
    }
    return handler->CurStableValue;
}

uint32_t Key_Filter_GetAsymmetricDebounceOutput(Key_FilterHandler_T *handler, uint32_t curUnfiltedValue)
{
    if (curUnfiltedValue == handler->InitValue) /* everything turns to the initial ones */
    {
/*
        handler->CurStableValue = handler->InitValue;
        handler->NewValue = curUnfiltedValue;
        handler->AccCounterForNewValue = 1U;
*/
        Key_Filter_Init(handler, handler->InitValue, handler->FilterCountMax+1U);
    }
    else
    {
        handler->CurStableValue = Key_Filter_GetSymmetricDebounceOutput(handler, curUnfiltedValue);
    }

    return handler->CurStableValue;
}

/* EOF. */
