/*! *********************************************************************************
* Copyright (c) 2015, Freescale Semiconductor, Inc.
* Copyright 2016-2017 NXP
* All rights reserved.
*
* \file
*
* SPDX-License-Identifier: BSD-3-Clause
********************************************************************************** */

#ifndef __DCDC_H__
#define __DCDC_H__

#include "EmbeddedTypes.h"


/*****************************************************************************
******************************************************************************
* Public macros
******************************************************************************
*****************************************************************************/

/*
 * NAME: gDCDC_Enabled_d
 * DESCRIPTION: Enables / Disables the DCDC platform component
 * VALID RANGE: TRUE/FALSE
 */
#ifndef gDCDC_Enabled_d
#define gDCDC_Enabled_d    0
#endif


#define  gDCDC_Mode_Bypass_c  0 
#define  gDCDC_Mode_Buck_c    1

#ifndef gDCDC_IsrPrio_c
#define gDCDC_IsrPrio_c       (0x80)
#endif

/*****************************************************************************
******************************************************************************
* Public type definitions
******************************************************************************
*****************************************************************************/
typedef enum
{
  gDCDC_PSwStatus_Low_c,
  gDCDC_PSwStatus_High_c
}dcdcPSwStatus_t;

typedef enum
{
  gDCDC_PSwIntEdge_Rising_c = 1,
  gDCDC_PSwIntEdge_Falling_c,
  gDCDC_PSwIntEdge_All_c
}dcdcPSwIntEdge_t;

typedef void (*pfDCDCPSwitchCallback_t)(dcdcPSwStatus_t);

typedef enum 
{
  gDCDC_Event_NoEvent_c = 0x0,
  gDCDC_Event_VBatOutOfRange_c = 0x1,
  gDCDC_Event_McuV_OutputTargetChange_c = 0x2,
  gDCDC_Event_1P8OutputTargetChange_c = 0x4  
}dcdcEvent_t;



typedef enum 
{
  gDCDC_McuV_OutputTargetVal_1_275_c = 0,
  gDCDC_McuV_OutputTargetVal_1_300_c,/* 0x01 */
  gDCDC_McuV_OutputTargetVal_1_325_c,/* 0x02 */
  gDCDC_McuV_OutputTargetVal_1_350_c,/* 0x03 */
  gDCDC_McuV_OutputTargetVal_1_375_c,/* 0x04 */
  gDCDC_McuV_OutputTargetVal_1_400_c,/* 0x05 */
  gDCDC_McuV_OutputTargetVal_1_425_c,/* 0x06 */
  gDCDC_McuV_OutputTargetVal_1_450_c,/* 0x07 */
  gDCDC_McuV_OutputTargetVal_1_475_c,/* 0x08 */
  gDCDC_McuV_OutputTargetVal_1_500_c,/* 0x09 */
  gDCDC_McuV_OutputTargetVal_1_525_c,/* 0x0A */
  gDCDC_McuV_OutputTargetVal_1_550_c,/* 0x0B */
  gDCDC_McuV_OutputTargetVal_1_575_c,/* 0x0C */
  gDCDC_McuV_OutputTargetVal_1_600_c,/* 0x0D */
  gDCDC_McuV_OutputTargetVal_1_625_c,/* 0x0E */
  gDCDC_McuV_OutputTargetVal_1_650_c,/* 0x0F */
  gDCDC_McuV_OutputTargetVal_1_675_c,/* 0x10 */
  gDCDC_McuV_OutputTargetVal_1_700_c,/* 0x11 */
  gDCDC_McuV_OutputTargetVal_1_725_c,/* 0x12 */
  gDCDC_McuV_OutputTargetVal_1_750_c,/* 0x13 */
  gDCDC_McuV_OutputTargetVal_1_775_c,/* 0x14 */
  gDCDC_McuV_OutputTargetVal_1_800_c,/* 0x15 */
  gDCDC_McuV_OutputTargetVal_MAX_c = gDCDC_McuV_OutputTargetVal_1_800_c 
}dcdcMcuVOutputTargetVal_t;

typedef enum 
{
  gDCDC_1P8OutputTargetVal_1_650_c = 0,
  gDCDC_1P8OutputTargetVal_1_675_c,
  gDCDC_1P8OutputTargetVal_1_700_c,
  gDCDC_1P8OutputTargetVal_1_725_c,
  gDCDC_1P8OutputTargetVal_1_750_c,
  gDCDC_1P8OutputTargetVal_1_775_c,
  gDCDC_1P8OutputTargetVal_1_800_c,
  gDCDC_1P8OutputTargetVal_1_825_c,
  gDCDC_1P8OutputTargetVal_1_850_c,
  gDCDC_1P8OutputTargetVal_1_875_c,
  gDCDC_1P8OutputTargetVal_1_900_c,
  gDCDC_1P8OutputTargetVal_1_925_c,
  gDCDC_1P8OutputTargetVal_1_950_c,
  gDCDC_1P8OutputTargetVal_1_975_c,
  gDCDC_1P8OutputTargetVal_2_000_c,
  gDCDC_1P8OutputTargetVal_2_025_c,
  gDCDC_1P8OutputTargetVal_2_050_c,
  gDCDC_1P8OutputTargetVal_2_075_c,
  gDCDC_1P8OutputTargetVal_2_100_c,
  gDCDC_1P8OutputTargetVal_2_150_c,
  gDCDC_1P8OutputTargetVal_2_200_c,
  gDCDC_1P8OutputTargetVal_2_250_c,
  gDCDC_1P8OutputTargetVal_2_300_c,
  gDCDC_1P8OutputTargetVal_2_350_c,
  gDCDC_1P8OutputTargetVal_2_400_c,
  gDCDC_1P8OutputTargetVal_2_450_c,
  gDCDC_1P8OutputTargetVal_2_500_c,
  gDCDC_1P8OutputTargetVal_2_550_c,
  gDCDC_1P8OutputTargetVal_2_600_c,
  gDCDC_1P8OutputTargetVal_2_650_c,
  gDCDC_1P8OutputTargetVal_2_700_c,
  gDCDC_1P8OutputTargetVal_2_750_c,
  gDCDC_1P8OutputTargetVal_2_800_c = 0x20,
  gDCDC_1P8OutputTargetVal_2_825_c,
  gDCDC_1P8OutputTargetVal_2_850_c,
  gDCDC_1P8OutputTargetVal_2_875_c,
  gDCDC_1P8OutputTargetVal_2_900_c,
  gDCDC_1P8OutputTargetVal_2_925_c,
  gDCDC_1P8OutputTargetVal_2_950_c,
  gDCDC_1P8OutputTargetVal_2_975_c,
  gDCDC_1P8OutputTargetVal_3_000_c,
  gDCDC_1P8OutputTargetVal_3_025_c,
  gDCDC_1P8OutputTargetVal_3_050_c,
  gDCDC_1P8OutputTargetVal_3_075_c,
  gDCDC_1P8OutputTargetVal_3_100_c,
  gDCDC_1P8OutputTargetVal_3_125_c,
  gDCDC_1P8OutputTargetVal_3_150_c,
  gDCDC_1P8OutputTargetVal_3_175_c,
  gDCDC_1P8OutputTargetVal_3_200_c,
  gDCDC_1P8OutputTargetVal_3_225_c,
  gDCDC_1P8OutputTargetVal_3_250_c,
  gDCDC_1P8OutputTargetVal_3_275_c,
  gDCDC_1P8OutputTargetVal_3_300_c,
  gDCDC_1P8OutputTargetVal_3_325_c,
  gDCDC_1P8OutputTargetVal_3_350_c,
  gDCDC_1P8OutputTargetVal_3_375_c,
  gDCDC_1P8OutputTargetVal_3_400_c,
  gDCDC_1P8OutputTargetVal_3_425_c,
  gDCDC_1P8OutputTargetVal_3_450_c,
  gDCDC_1P8OutputTargetVal_3_475_c,
  gDCDC_1P8OutputTargetVal_3_500_c,
  gDCDC_1P8OutputTargetVal_MAX_c = gDCDC_1P8OutputTargetVal_3_500_c 
 }dcdc1P8OutputTargetVal_t;

typedef struct dcdcCalbackParam_tag
{
  dcdcEvent_t dcdcEvent;
  dcdcMcuVOutputTargetVal_t dcdcMcuVOutputTargetVal;
  dcdc1P8OutputTargetVal_t dcdc1P8OutputTargetVal;
  uint16_t dcdc1P8OutputMeasuredVal;
  uint16_t dcdcVbatMeasuredVal;
}dcdcCallbackParam_t;
typedef void (*pfDCDCAppCallback_t)(const dcdcCallbackParam_t*);

typedef struct dcdcConfig_tag
{
  uint16_t vbatMin;
  uint16_t vbatMax;
  uint8_t dcdcMode;
  uint32_t vBatMonitorIntervalMs;
  pfDCDCAppCallback_t pfDCDCAppCallback; 
  dcdcMcuVOutputTargetVal_t dcdcMcuVOutputTargetVal;
  dcdc1P8OutputTargetVal_t  dcdc1P8OutputTargetVal;
}dcdcConfig_t;

/*****************************************************************************
******************************************************************************
* Public memory declarations
******************************************************************************
*****************************************************************************/

/* none */

/*****************************************************************************
******************************************************************************
* Public prototypes
******************************************************************************
*****************************************************************************/


/*---------------------------------------------------------------------------
 * NAME: DCDC_Init
 * DESCRIPTION: initialize the DCDC module
 * PARAMETERS: -
 * RETURN: -
 *---------------------------------------------------------------------------*/
extern bool_t DCDC_Init
(
    const dcdcConfig_t * pDCDCConfig
);

/*---------------------------------------------------------------------------
 * NAME: DCDC_SetOutputVoltageTargets
 * DESCRIPTION: initialize the timer module
 * PARAMETERS: -
 * RETURN: -
 *---------------------------------------------------------------------------*/
bool_t DCDC_SetOutputVoltageTargets
(
dcdcMcuVOutputTargetVal_t dcdcMcuVOutputTargetVal,
dcdc1P8OutputTargetVal_t  dcdc1P8OutputTargetVal
);

///*---------------------------------------------------------------------------
//* NAME: DCDC_McuVOutputTargetTomV
//* DESCRIPTION: 
//* PARAMETERS:  
//* RETURN: 
//* NOTES: none
//*---------------------------------------------------------------------------*/
uint16_t DCDC_McuVOutputTargetTomV(dcdcMcuVOutputTargetVal_t dcdcMcuVOutputTarget);
///*---------------------------------------------------------------------------
//* NAME: DCDC_1P8OutputTargetTomV
//* DESCRIPTION: 
//* PARAMETERS:  
//* RETURN: 
//* NOTES: none
//*---------------------------------------------------------------------------*/
uint16_t DCDC_1P8OutputTargetTomV(dcdc1P8OutputTargetVal_t dcdc1P8OutputTarget);
///*---------------------------------------------------------------------------
//* NAME: DCDC_PrepareForPulsedMode
//* DESCRIPTION: 
//* PARAMETERS:  
//* RETURN: 
//* NOTES: none
//*---------------------------------------------------------------------------*/
bool_t DCDC_PrepareForPulsedMode(void);
///*---------------------------------------------------------------------------
//* NAME: DCDC_PrepareForContinuousMode
//* DESCRIPTION: 
//* PARAMETERS:  
//* RETURN: 
//* NOTES: none
//*---------------------------------------------------------------------------*/
bool_t DCDC_PrepareForContinuousMode(void);

///*---------------------------------------------------------------------------
//* NAME: DCDC_SetUpperLimitDutyCycle
//* DESCRIPTION: 
//* PARAMETERS:  
//* RETURN: 
//* NOTES: none
//*---------------------------------------------------------------------------*/
bool_t DCDC_SetUpperLimitDutyCycle(uint8_t upperLimitDutyCycle);

///*---------------------------------------------------------------------------
//* NAME: DCDC_GetPowerSwitchStatus
//* DESCRIPTION: 
//* PARAMETERS:  
//* RETURN: 
//* NOTES: none
//*---------------------------------------------------------------------------*/
bool_t DCDC_GetPowerSwitchStatus(dcdcPSwStatus_t* pDCDCPSwStatus);
///*---------------------------------------------------------------------------
//* NAME: DCDC_ShutDown
//* DESCRIPTION: 
//* PARAMETERS:  
//* RETURN: 
//* NOTES: none
//*---------------------------------------------------------------------------*/
void DCDC_ShutDown(void);
///*---------------------------------------------------------------------------
//* NAME: DCDC_InstallPSwitchCallback
//* DESCRIPTION: 
//* PARAMETERS:  
//* RETURN: 
//* NOTES: none
//*---------------------------------------------------------------------------*/
bool_t DCDC_InstallPSwitchCallback(pfDCDCPSwitchCallback_t pfPSwCallback, dcdcPSwIntEdge_t pSwIntEdge);
#endif /* #ifndef __DCDC_H__ */

/*****************************************************************************
 *                               <<< EOF >>>                                 *
 *****************************************************************************/
