#!/usr/bin/env python

###############################################################################
#
# Copyright 2017 - 2019 NXP
# All rights reserved.
#
# SPDX-License-Identifier: BSD-3-Clause
#
###############################################################################

# DESCRIPTION:        Load TFLite model and allocate tensors
# INPUT/S:            TFLite
# OUTPUT/S:           Tensor Data

import numpy as np
import tensorflow as tf


###################################################################
# Main function
###################################################################    

if __name__ == "__main__":
    
    print ("="*73)
    print ("="*32," Start ","="*32)
    print ("="*73)
    
    
    try:
        # Load TFLite model and allocate tensors.
        interpreter = tf.lite.Interpreter(model_path="../TFlite_Model/converted_model_new.tflite")
        
        interpreter.allocate_tensors()
        
        # Get input and output tensors.
        input_details = interpreter.get_input_details()
        output_details = interpreter.get_output_details()
        
        # Test model on random input data.
        input_shape = input_details[0]['shape']
        input_data = np.array([395 , 255 , 303 , 392 , 316 , 296 , 302 , 330 , 293 , 286 , 329 , 274 , 263 , 346 , 338 , 257 , 334 , 347 , 352 , 331 , 386 , 383 , 295 , 373 , 389 , 253 , 355 , 398 , 300 , 291 , 367 , 282 ,2207 ,1730 ,2133 ,1383 , 610 , 857 , 681 , 395 , 558 , 417 , 362 , 278 , 480 , 367 ,2161 ,2220 ,1321 ,1169 , 988 , 719 , 542 , 439 , 405 , 322 , 353 , 348 , 327 , 329 , 327 , 417 ,2955 ,1612 ,2007 ,1434 , 834 , 754 , 512 , 393 , 271 , 409 , 406 , 321 , 341 , 358 , 408 , 309 ,2711 ,2084 ,2014 ,1085 ,1035 , 610 , 635 , 483 , 406 , 314 , 341 , 420 , 249 , 274 , 391 , 313 , 333 , 304 ,3056 ,1898 ,1544 ,1352 ,1110 ,1070 , 543 , 442 , 446 , 366 , 432 , 361 , 277 , 389 , 310 , 363 , 314 , 379 , 279 , 322 , 389 , 360 , 337 , 383 , 352 , 297 , 333 , 327 , 310 , 283 , 354 , 359 , 289 , 338 , 365 , 278 , 333 , 348 , 352 , 260 , 334 , 407 , 317 , 291 , 365 , 393 , 304 , 346 , 349 , 369 , 353 , 399 , 347 , 284 , 411 , 415 , 300 , 354 , 457 , 315 , 367 , 411 , 299 , 342 , 402 , 430 , 290 , 381 , 395 , 329 , 394 , 362 , 319 , 322 , 402 , 345 , 293 , 339 , 355 , 368 , 275 , 386 , 332 , 305 , 399 , 358 , 283 , 411 , 355 , 294 , 420 , 362 , 353 , 319 , 403 , 399 , 258 , 336 , 407 , 316 , 261 , 418 , 373 , 266])
        
        input_data = np.reshape(input_data,[1,200,1])
        interpreter.set_tensor(input_details[0]['index'], input_data)
        interpreter.invoke()
        
        # The function `get_tensor()` returns a copy of the tensor data.
        # Use `tensor()` in order to get a pointer to the tensor.
        output_data = interpreter.get_tensor(output_details[0]['index'])
        print("\nOutput Tensor Data:\n")
        print(output_data)
        
    except:
        print ("\n*** TFLite model is not existing ***\n")
    
    print ("="*73)
    print ("="*33," End ","="*33)
    print ("="*73)

