/*
 * Copyright 2019 NXP
 * All rights reserved.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 */

#ifndef MAIN_H2_
#define MAIN_H2_

#include "fsl_debug_console.h"
#include "fsl_fxos.h"
#include "board.h"
#include "fsl_gpt.h"

#include "fsl_common.h"
#include "pin_mux.h"
#include "fsl_iomuxc.h"
#include "fsl_gpio.h"
#include "fsl_lpuart.h"
#include <vibration_data.h>

/*******************************************************************************
 * Definitions
 ******************************************************************************/
/* I2C definition */
#define ACCEL_I2C_CLK_SRC I2C1_CLK_SRC
#define I2C_BAUDRATE 100000U
#define ACCEL_I2C_ADDR 1FU

#define I2C_RELEASE_BUS_COUNT 100U

#define ACCEL_I2C_SCL_GPIO GPIO1
#define ACCEL_I2C_SCL_PIN 16
#define ACCEL_I2C_SDA_GPIO GPIO1
#define ACCEL_I2C_SDA_PIN 17

/*******************************************************************************
 * Timer
 ******************************************************************************/
#define GPT_IRQ_ID GPT2_IRQn
#define EXAMPLE_GPT GPT2

/* Get source clock for GPT driver (GPT prescaler = 0) */
#define EXAMPLE_GPT_CLK_FREQ CLOCK_GetFreq(kCLOCK_PerClk)

#define EXAMPLE_LED_GPIO BOARD_USER_LED_GPIO
#define EXAMPLE_LED_GPIO_PIN BOARD_USER_LED_GPIO_PIN

#if defined(__cplusplus)
extern "C" {
#endif /* __cplusplus*/


/*******************************************************************************
 * Prototypes
 ******************************************************************************/
void BOARD_I2C_ReleaseBus(void);
/*!
 * @brief Read Accelerometer data
 * @param xp The pointer store x axis acceleration value
 * @param yp The pointer store y axis acceleration value
 * @param zp The pointer store z axis acceleration value
 *
 */

int ACCEL_GetAccelData(int16_t *xp, int16_t *yp, int16_t *zp);
void Calculate_RMS(void);

#if defined(FSL_FEATURE_SOC_LPI2C_COUNT) && (FSL_FEATURE_SOC_LPI2C_COUNT)
extern void FXOS_master_callback(LPI2C_Type *base, lpi2c_master_handle_t *handle, status_t status, void *userData);
lpi2c_master_handle_t g_MasterHandle;
#else
i2c_master_handle_t g_MasterHandle;
#endif


#if defined(__cplusplus)
}
#endif /* __cplusplus*/

/*******************************************************************************
 * Variables
 ******************************************************************************/

volatile bool gptIsrFlag = false;
fxos_handle_t g_fxosHandle;
uint8_t g_sensor_address[] = {0x1CU,0x1EU,0x1DU,0x1FU};
uint8_t g_sensorRange = 0;
uint8_t g_dataScale = 0;
int16_t Ax = 0, Ay = 0, Az = 0;
#endif /* MAIN_H2_ */
