/*******************************************************************************
*
* E M B E D D E D   W I Z A R D   P R O J E C T
*
*                                                Copyright (c) TARA Systems GmbH
*                                    written by Paul Banach and Manfred Schweyer
*
********************************************************************************
*
* This file was generated automatically by Embedded Wizard Studio.
*
* Please do not make any modifications of this file! The modifications are lost
* when the file is generated again by Embedded Wizard Studio!
*
* The template of this heading text can be found in the file 'head.ewt' in the
* directory 'Platforms' of your Embedded Wizard installation directory. If you
* wish to adapt this text, please copy the template file 'head.ewt' into your
* project directory and edit the copy only. Please avoid any modifications of
* the original template file!
*
* Version  : 11.00
* Profile  : iMX_RT
* Platform : NXP.iMX_RT.RGBA8888
*
*******************************************************************************/

#include <stdint.h>
#include <stddef.h>
#include <stdlib.h>

#include "input_proc.h"

#include "ewlocale.h"
#include "_ApplicationApplication.h"
#include "_CoreSimpleTouchHandler.h"
#include "_CoreView.h"
#include "_GraphicsCanvas.h"
#include "_ResourcesBitmap.h"
#include "_ResourcesFont.h"
#include "_ViewsBorder.h"
#include "_ViewsImage.h"
#include "_ViewsRectangle.h"
#include "_ViewsText.h"
#include "_WidgetSetPushButton.h"
#include "_WidgetSetPushButtonConfig.h"
#include "Application.h"
#include "Core.h"
#include "Resources.h"
#include "WidgetSet.h"

#define ADD_PIXELS 4

/* Compressed strings for the language 'Default'. */
EW_CONST_STRING_PRAGMA static const unsigned int _StringsDefault0[] =
{
  0x000000AC, /* ratio 69.77 % */
  0xB8000F00, 0x80098452, 0x00C60037, 0x61A00358, 0xAA458182, 0x80037000, 0x0B84C1CD,
  0x0040021B, 0x39000AF1, 0xD19E2917, 0x90E200A8, 0x9641208B, 0x634748C1, 0x004F8801,
  0x00F8D12C, 0x2B0014E2, 0x0000825B, 0x00184005, 0xB8028073, 0x19001283, 0xE22B269A,
  0xC011F9F4, 0x550A9BCE, 0x50D8A52E, 0x08834120, 0xC86C3215, 0x8B49E091, 0xD4827F2B,
  0x002031A8, 0x00000000
};

/* Constant values used in this 'C' module only. */
static const XRect _Const0000 = {{ 0, 0 }, { 480, 272 }};
static const XColor _Const0001 = { 0x00, 0x00, 0x00, 0xFF };
static const XRect _Const0002 = {{ 7, 8 }, { 119, 120 }};
static const XPoint _Const0003 = { 112, 112 };
static const XPoint _Const0004 = { 7, 8 };
static const XPoint _Const0005 = { 119, 8 };
static const XPoint _Const0006 = { 119, 120 };
static const XPoint _Const0007 = { 7, 120 };
static const XRect _Const0008 = {{ 125, 8 }, { 237, 120 }};
static const XPoint _Const0009 = { 125, 8 };
static const XPoint _Const000A = { 237, 8 };
static const XPoint _Const000B = { 237, 120 };
static const XPoint _Const000C = { 125, 120 };
static const XRect _Const000D = {{ 243, 8 }, { 355, 120 }};
static const XPoint _Const000E = { 243, 8 };
static const XPoint _Const000F = { 355, 8 };
static const XPoint _Const0010 = { 355, 120 };
static const XPoint _Const0011 = { 243, 120 };
static const XRect _Const0012 = {{ 361, 8 }, { 473, 120 }};
static const XPoint _Const0013 = { 361, 8 };
static const XPoint _Const0014 = { 473, 8 };
static const XPoint _Const0015 = { 473, 120 };
static const XPoint _Const0016 = { 361, 120 };
static const XRect _Const0017 = {{ 6, 7 }, { 120, 121 }};
static const XRect _Const0018 = {{ 124, 7 }, { 238, 121 }};
static const XRect _Const0019 = {{ 242, 7 }, { 356, 121 }};
static const XRect _Const001A = {{ 360, 7 }, { 474, 121 }};
static const XRect _Const001B = {{ 0, 185 }, { 123, 227 }};
static const XStringRes _Const001C = { _StringsDefault0, 0x0029 };
static const XRect _Const001D = {{ 0, 227 }, { 123, 269 }};
static const XStringRes _Const001E = { _StringsDefault0, 0x0038 };
static const XRect _Const001F = {{ 168, 185 }, { 313, 269 }};
static const XStringRes _Const0020 = { _StringsDefault0, 0x0047 };
static const XRect _Const0021 = {{ 372, 190 }, { 462, 222 }};
static const XRect _Const0022 = {{ 366, 227 }, { 468, 258 }};
static const XRect _Const0023 = {{ 23, 121 }, { 103, 155 }};
static const XStringRes _Const0024 = { _StringsDefault0, 0x004E };
static const XRect _Const0025 = {{ 141, 121 }, { 221, 155 }};
static const XRect _Const0026 = {{ 259, 121 }, { 339, 155 }};
static const XRect _Const0027 = {{ 377, 121 }, { 457, 155 }};
static const XColor _Const0028 = { 0x00, 0x00, 0x00, 0x00 };
int password[4] = { 0, 0, 0, 0 };
int locked = 0;

/* Initializer for the class 'Application::Application' */
void ApplicationApplication__Init( ApplicationApplication _this, XObject aLink, XHandle aArg )
{
  /* At first initialize the super class ... */
  CoreRoot__Init( &_this->_.Super, aLink, aArg );

  /* Allow the Immediate Garbage Collection to evalute the members of this class. */
  _this->_.XObject._.GCT = EW_CLASS_GCT( ApplicationApplication );

  /* ... then construct all embedded objects */
  ViewsRectangle__Init( &_this->Rectangle, &_this->_.XObject, 0 );
  ViewsImage__Init( &_this->Image1, &_this->_.XObject, 0 );
  GraphicsCanvas__Init( &_this->Canvas1, &_this->_.XObject, 0 );
  CoreSimpleTouchHandler__Init( &_this->SimpleTouchHandler1, &_this->_.XObject, 0 );
  ViewsImage__Init( &_this->Image2, &_this->_.XObject, 0 );
  GraphicsCanvas__Init( &_this->Canvas2, &_this->_.XObject, 0 );
  CoreSimpleTouchHandler__Init( &_this->SimpleTouchHandler2, &_this->_.XObject, 0 );
  ViewsImage__Init( &_this->Image3, &_this->_.XObject, 0 );
  GraphicsCanvas__Init( &_this->Canvas3, &_this->_.XObject, 0 );
  CoreSimpleTouchHandler__Init( &_this->SimpleTouchHandler3, &_this->_.XObject, 0 );
  ViewsImage__Init( &_this->Image4, &_this->_.XObject, 0 );
  GraphicsCanvas__Init( &_this->Canvas4, &_this->_.XObject, 0 );
  CoreSimpleTouchHandler__Init( &_this->SimpleTouchHandler4, &_this->_.XObject, 0 );
  ViewsBorder__Init( &_this->Border1, &_this->_.XObject, 0 );
  ViewsBorder__Init( &_this->Border2, &_this->_.XObject, 0 );
  ViewsBorder__Init( &_this->Border3, &_this->_.XObject, 0 );
  ViewsBorder__Init( &_this->Border4, &_this->_.XObject, 0 );
  WidgetSetPushButton__Init( &_this->SetPasswordButton, &_this->_.XObject, 0 );
  WidgetSetPushButton__Init( &_this->ClearScreenButton, &_this->_.XObject, 0 );
  WidgetSetPushButton__Init( &_this->LockButton, &_this->_.XObject, 0 );
  ViewsText__Init( &_this->ResultsText, &_this->_.XObject, 0 );
  ViewsText__Init( &_this->InfoText, &_this->_.XObject, 0 );
  WidgetSetPushButton__Init( &_this->Clear1Button, &_this->_.XObject, 0 );
  WidgetSetPushButton__Init( &_this->Clear2Button, &_this->_.XObject, 0 );
  WidgetSetPushButton__Init( &_this->Clear3Button, &_this->_.XObject, 0 );
  WidgetSetPushButton__Init( &_this->Clear4Button, &_this->_.XObject, 0 );

  /* Setup the VMT pointer */
  _this->_.VMT = EW_CLASS( ApplicationApplication );

  /* ... and initialize objects, variables, properties, etc. */
  CoreRectView__OnSetBounds( _this, _Const0000 );
  CoreRectView__OnSetBounds( &_this->Rectangle, _Const0000 );
  ViewsRectangle_OnSetColor( &_this->Rectangle, _Const0001 );
  CoreRectView__OnSetBounds( &_this->Image1, _Const0002 );
  ResourcesBitmap__OnSetFrameSize( &_this->Canvas1, _Const0003 );
  CoreQuadView_OnSetPoint4((CoreQuadView)&_this->SimpleTouchHandler1, _Const0004 );
  CoreQuadView_OnSetPoint3((CoreQuadView)&_this->SimpleTouchHandler1, _Const0005 );
  CoreQuadView_OnSetPoint2((CoreQuadView)&_this->SimpleTouchHandler1, _Const0006 );
  CoreQuadView_OnSetPoint1((CoreQuadView)&_this->SimpleTouchHandler1, _Const0007 );
  CoreRectView__OnSetBounds( &_this->Image2, _Const0008 );
  ResourcesBitmap__OnSetFrameSize( &_this->Canvas2, _Const0003 );
  CoreQuadView_OnSetPoint4((CoreQuadView)&_this->SimpleTouchHandler2, _Const0009 );
  CoreQuadView_OnSetPoint3((CoreQuadView)&_this->SimpleTouchHandler2, _Const000A );
  CoreQuadView_OnSetPoint2((CoreQuadView)&_this->SimpleTouchHandler2, _Const000B );
  CoreQuadView_OnSetPoint1((CoreQuadView)&_this->SimpleTouchHandler2, _Const000C );
  CoreRectView__OnSetBounds( &_this->Image3, _Const000D );
  ResourcesBitmap__OnSetFrameSize( &_this->Canvas3, _Const0003 );
  CoreQuadView_OnSetPoint4((CoreQuadView)&_this->SimpleTouchHandler3, _Const000E );
  CoreQuadView_OnSetPoint3((CoreQuadView)&_this->SimpleTouchHandler3, _Const000F );
  CoreQuadView_OnSetPoint2((CoreQuadView)&_this->SimpleTouchHandler3, _Const0010 );
  CoreQuadView_OnSetPoint1((CoreQuadView)&_this->SimpleTouchHandler3, _Const0011 );
  CoreRectView__OnSetBounds( &_this->Image4, _Const0012 );
  ResourcesBitmap__OnSetFrameSize( &_this->Canvas4, _Const0003 );
  CoreQuadView_OnSetPoint4((CoreQuadView)&_this->SimpleTouchHandler4, _Const0013 );
  CoreQuadView_OnSetPoint3((CoreQuadView)&_this->SimpleTouchHandler4, _Const0014 );
  CoreQuadView_OnSetPoint2((CoreQuadView)&_this->SimpleTouchHandler4, _Const0015 );
  CoreQuadView_OnSetPoint1((CoreQuadView)&_this->SimpleTouchHandler4, _Const0016 );
  CoreRectView__OnSetBounds( &_this->Border1, _Const0017 );
  ViewsBorder_OnSetColor( &_this->Border1, ApplicationMainColor );
  CoreRectView__OnSetBounds( &_this->Border2, _Const0018 );
  ViewsBorder_OnSetColor( &_this->Border2, ApplicationMainColor );
  CoreRectView__OnSetBounds( &_this->Border3, _Const0019 );
  ViewsBorder_OnSetColor( &_this->Border3, ApplicationMainColor );
  CoreRectView__OnSetBounds( &_this->Border4, _Const001A );
  ViewsBorder_OnSetColor( &_this->Border4, ApplicationMainColor );
  CoreRectView__OnSetBounds( &_this->SetPasswordButton, _Const001B );
  WidgetSetPushButton_OnSetLabel( &_this->SetPasswordButton, EwLoadString( &_Const001C ));
  CoreRectView__OnSetBounds( &_this->ClearScreenButton, _Const001D );
  WidgetSetPushButton_OnSetLabel( &_this->ClearScreenButton, EwLoadString( &_Const001E ));
  CoreRectView__OnSetBounds( &_this->LockButton, _Const001F );
  WidgetSetPushButton_OnSetLabel( &_this->LockButton, EwLoadString( &_Const0020 ));
  CoreRectView__OnSetBounds( &_this->ResultsText, _Const0021 );
  ViewsText_OnSetString( &_this->ResultsText, 0 );
  ViewsText_OnSetColor( &_this->ResultsText, ApplicationMainColor );
  CoreRectView__OnSetBounds( &_this->InfoText, _Const0022 );
  ViewsText_OnSetString( &_this->InfoText, 0 );
  ViewsText_OnSetColor( &_this->InfoText, ApplicationMainColor );
  CoreRectView__OnSetBounds( &_this->Clear1Button, _Const0023 );
  WidgetSetPushButton_OnSetLabel( &_this->Clear1Button, EwLoadString( &_Const0024 ));
  CoreRectView__OnSetBounds( &_this->Clear2Button, _Const0025 );
  WidgetSetPushButton_OnSetLabel( &_this->Clear2Button, EwLoadString( &_Const0024 ));
  CoreRectView__OnSetBounds( &_this->Clear3Button, _Const0026 );
  WidgetSetPushButton_OnSetLabel( &_this->Clear3Button, EwLoadString( &_Const0024 ));
  CoreRectView__OnSetBounds( &_this->Clear4Button, _Const0027 );
  WidgetSetPushButton_OnSetLabel( &_this->Clear4Button, EwLoadString( &_Const0024 ));
  CoreGroup_Add((CoreGroup)_this, ((CoreView)&_this->Rectangle ), 0 );
  CoreGroup_Add((CoreGroup)_this, ((CoreView)&_this->Image1 ), 0 );
  CoreGroup_Add((CoreGroup)_this, ((CoreView)&_this->SimpleTouchHandler1 ), 0 );
  CoreGroup_Add((CoreGroup)_this, ((CoreView)&_this->Image2 ), 0 );
  CoreGroup_Add((CoreGroup)_this, ((CoreView)&_this->SimpleTouchHandler2 ), 0 );
  CoreGroup_Add((CoreGroup)_this, ((CoreView)&_this->Image3 ), 0 );
  CoreGroup_Add((CoreGroup)_this, ((CoreView)&_this->SimpleTouchHandler3 ), 0 );
  CoreGroup_Add((CoreGroup)_this, ((CoreView)&_this->Image4 ), 0 );
  CoreGroup_Add((CoreGroup)_this, ((CoreView)&_this->SimpleTouchHandler4 ), 0 );
  CoreGroup_Add((CoreGroup)_this, ((CoreView)&_this->Border1 ), 0 );
  CoreGroup_Add((CoreGroup)_this, ((CoreView)&_this->Border2 ), 0 );
  CoreGroup_Add((CoreGroup)_this, ((CoreView)&_this->Border3 ), 0 );
  CoreGroup_Add((CoreGroup)_this, ((CoreView)&_this->Border4 ), 0 );
  CoreGroup_Add((CoreGroup)_this, ((CoreView)&_this->SetPasswordButton ), 0 );
  CoreGroup_Add((CoreGroup)_this, ((CoreView)&_this->ClearScreenButton ), 0 );
  CoreGroup_Add((CoreGroup)_this, ((CoreView)&_this->LockButton ), 0 );
  CoreGroup_Add((CoreGroup)_this, ((CoreView)&_this->ResultsText ), 0 );
  CoreGroup_Add((CoreGroup)_this, ((CoreView)&_this->InfoText ), 0 );
  CoreGroup_Add((CoreGroup)_this, ((CoreView)&_this->Clear1Button ), 0 );
  CoreGroup_Add((CoreGroup)_this, ((CoreView)&_this->Clear2Button ), 0 );
  CoreGroup_Add((CoreGroup)_this, ((CoreView)&_this->Clear3Button ), 0 );
  CoreGroup_Add((CoreGroup)_this, ((CoreView)&_this->Clear4Button ), 0 );
  ViewsImage_OnSetBitmap( &_this->Image1, ((ResourcesBitmap)&_this->Canvas1 ));
  _this->SimpleTouchHandler1.OnDrag = EwNewSlot( _this, ApplicationApplication_onDrag1 );
  ViewsImage_OnSetBitmap( &_this->Image2, ((ResourcesBitmap)&_this->Canvas2 ));
  _this->SimpleTouchHandler2.OnDrag = EwNewSlot( _this, ApplicationApplication_onDrag2 );
  ViewsImage_OnSetBitmap( &_this->Image3, ((ResourcesBitmap)&_this->Canvas3 ));
  _this->SimpleTouchHandler3.OnDrag = EwNewSlot( _this, ApplicationApplication_onDrag3 );
  ViewsImage_OnSetBitmap( &_this->Image4, ((ResourcesBitmap)&_this->Canvas4 ));
  _this->SimpleTouchHandler4.OnDrag = EwNewSlot( _this, ApplicationApplication_onDrag4 );
  CoreGroup__OnSetFocus( &_this->SetPasswordButton, 0 );
  _this->SetPasswordButton.OnPress = EwNewSlot( _this, ApplicationApplication_onPressSetPassword );
  WidgetSetPushButton_OnSetAppearance( &_this->SetPasswordButton, EwGetAutoObject( 
  &WidgetSetPushButton_Small, WidgetSetPushButtonConfig ));
  _this->ClearScreenButton.OnPress = EwNewSlot( _this, ApplicationApplication_onPressClearScreen );
  WidgetSetPushButton_OnSetAppearance( &_this->ClearScreenButton, EwGetAutoObject( 
  &WidgetSetPushButton_Small, WidgetSetPushButtonConfig ));
  _this->LockButton.OnPress = EwNewSlot( _this, ApplicationApplication_onPressLock );
  WidgetSetPushButton_OnSetAppearance( &_this->LockButton, EwGetAutoObject( &WidgetSetPushButton_Medium, 
  WidgetSetPushButtonConfig ));
  ViewsText_OnSetFont( &_this->ResultsText, EwLoadResource( &ResourcesFontLarge, 
  ResourcesFont ));
  ViewsText_OnSetFont( &_this->InfoText, EwLoadResource( &ResourcesFontLarge, ResourcesFont ));
  _this->Clear1Button.OnPress = EwNewSlot( _this, ApplicationApplication_onPressClear1 );
  WidgetSetPushButton_OnSetAppearance( &_this->Clear1Button, EwGetAutoObject( &WidgetSetPushButton_Small, 
  WidgetSetPushButtonConfig ));
  _this->Clear2Button.OnPress = EwNewSlot( _this, ApplicationApplication_onPressClear2 );
  WidgetSetPushButton_OnSetAppearance( &_this->Clear2Button, EwGetAutoObject( &WidgetSetPushButton_Small, 
  WidgetSetPushButtonConfig ));
  _this->Clear3Button.OnPress = EwNewSlot( _this, ApplicationApplication_onPressClear3 );
  WidgetSetPushButton_OnSetAppearance( &_this->Clear3Button, EwGetAutoObject( &WidgetSetPushButton_Small, 
  WidgetSetPushButtonConfig ));
  _this->Clear4Button.OnPress = EwNewSlot( _this, ApplicationApplication_onPressClear4 );
  WidgetSetPushButton_OnSetAppearance( &_this->Clear4Button, EwGetAutoObject( &WidgetSetPushButton_Small, 
  WidgetSetPushButtonConfig ));

  /* Call the user defined constructor */
  ApplicationApplication_Init( _this, aArg );
}

/* Re-Initializer for the class 'Application::Application' */
void ApplicationApplication__ReInit( ApplicationApplication _this )
{
  /* At first re-initialize the super class ... */
  CoreRoot__ReInit( &_this->_.Super );

  /* ... then re-construct all embedded objects */
  ViewsRectangle__ReInit( &_this->Rectangle );
  ViewsImage__ReInit( &_this->Image1 );
  GraphicsCanvas__ReInit( &_this->Canvas1 );
  CoreSimpleTouchHandler__ReInit( &_this->SimpleTouchHandler1 );
  ViewsImage__ReInit( &_this->Image2 );
  GraphicsCanvas__ReInit( &_this->Canvas2 );
  CoreSimpleTouchHandler__ReInit( &_this->SimpleTouchHandler2 );
  ViewsImage__ReInit( &_this->Image3 );
  GraphicsCanvas__ReInit( &_this->Canvas3 );
  CoreSimpleTouchHandler__ReInit( &_this->SimpleTouchHandler3 );
  ViewsImage__ReInit( &_this->Image4 );
  GraphicsCanvas__ReInit( &_this->Canvas4 );
  CoreSimpleTouchHandler__ReInit( &_this->SimpleTouchHandler4 );
  ViewsBorder__ReInit( &_this->Border1 );
  ViewsBorder__ReInit( &_this->Border2 );
  ViewsBorder__ReInit( &_this->Border3 );
  ViewsBorder__ReInit( &_this->Border4 );
  WidgetSetPushButton__ReInit( &_this->SetPasswordButton );
  WidgetSetPushButton__ReInit( &_this->ClearScreenButton );
  WidgetSetPushButton__ReInit( &_this->LockButton );
  ViewsText__ReInit( &_this->ResultsText );
  ViewsText__ReInit( &_this->InfoText );
  WidgetSetPushButton__ReInit( &_this->Clear1Button );
  WidgetSetPushButton__ReInit( &_this->Clear2Button );
  WidgetSetPushButton__ReInit( &_this->Clear3Button );
  WidgetSetPushButton__ReInit( &_this->Clear4Button );
}

/* Finalizer method for the class 'Application::Application' */
void ApplicationApplication__Done( ApplicationApplication _this )
{
  /* Finalize this class */
  _this->_.Super._.VMT = EW_CLASS( CoreRoot );

  /* Finalize all embedded objects */
  ViewsRectangle__Done( &_this->Rectangle );
  ViewsImage__Done( &_this->Image1 );
  GraphicsCanvas__Done( &_this->Canvas1 );
  CoreSimpleTouchHandler__Done( &_this->SimpleTouchHandler1 );
  ViewsImage__Done( &_this->Image2 );
  GraphicsCanvas__Done( &_this->Canvas2 );
  CoreSimpleTouchHandler__Done( &_this->SimpleTouchHandler2 );
  ViewsImage__Done( &_this->Image3 );
  GraphicsCanvas__Done( &_this->Canvas3 );
  CoreSimpleTouchHandler__Done( &_this->SimpleTouchHandler3 );
  ViewsImage__Done( &_this->Image4 );
  GraphicsCanvas__Done( &_this->Canvas4 );
  CoreSimpleTouchHandler__Done( &_this->SimpleTouchHandler4 );
  ViewsBorder__Done( &_this->Border1 );
  ViewsBorder__Done( &_this->Border2 );
  ViewsBorder__Done( &_this->Border3 );
  ViewsBorder__Done( &_this->Border4 );
  WidgetSetPushButton__Done( &_this->SetPasswordButton );
  WidgetSetPushButton__Done( &_this->ClearScreenButton );
  WidgetSetPushButton__Done( &_this->LockButton );
  ViewsText__Done( &_this->ResultsText );
  ViewsText__Done( &_this->InfoText );
  WidgetSetPushButton__Done( &_this->Clear1Button );
  WidgetSetPushButton__Done( &_this->Clear2Button );
  WidgetSetPushButton__Done( &_this->Clear3Button );
  WidgetSetPushButton__Done( &_this->Clear4Button );

  /* Don't forget to deinitialize the super class ... */
  CoreRoot__Done( &_this->_.Super );
}

/* The method Init() is invoked automatically after the component has been created. 
   This method can be overridden and filled with logic containing additional initialization 
   statements. */
void ApplicationApplication_Init( ApplicationApplication _this, XHandle aArg )
{
  /* Dummy expressions to avoid the 'C' warning 'unused argument'. */
  EW_UNUSED_ARG( aArg );

  GraphicsCanvas_FillRectangle( &_this->Canvas1, EwGetRectORect( _this->Image1.Super1.Bounds ), 
  EwGetRectORect( _this->Image1.Super1.Bounds ), _Const0028, _Const0028, _Const0028, 
  _Const0028, 0 );
  GraphicsCanvas_FillRectangle( &_this->Canvas2, EwGetRectORect( _this->Image2.Super1.Bounds ), 
  EwGetRectORect( _this->Image2.Super1.Bounds ), _Const0028, _Const0028, _Const0028, 
  _Const0028, 0 );
  GraphicsCanvas_FillRectangle( &_this->Canvas3, EwGetRectORect( _this->Image3.Super1.Bounds ), 
  EwGetRectORect( _this->Image3.Super1.Bounds ), _Const0028, _Const0028, _Const0028, 
  _Const0028, 0 );
  GraphicsCanvas_FillRectangle( &_this->Canvas4, EwGetRectORect( _this->Image4.Super1.Bounds ), 
  EwGetRectORect( _this->Image4.Super1.Bounds ), _Const0028, _Const0028, _Const0028, 
  _Const0028, 0 );
  CoreView__ChangeViewState( &_this->SetPasswordButton, (XSet)0, CoreViewStateFocused );
  CoreView__ChangeViewState( &_this->ClearScreenButton, (XSet)0, CoreViewStateFocused );
  CoreView__ChangeViewState( &_this->LockButton, (XSet)0, CoreViewStateFocused );
}

/* 'C' function for method : 'Application::Application.onDrag1()' */
void ApplicationApplication_onDrag1( ApplicationApplication _this, XObject sender )
{
  XColor clr;

  /* Dummy expressions to avoid the 'C' warning 'unused argument'. */
  EW_UNUSED_ARG( sender );

  clr = ApplicationMainColor;
  GraphicsCanvas_DrawLine( &_this->Canvas1, EwGetRectORect( _this->Image1.Super1.Bounds ), 
  EwMovePointNeg( EwMovePointNeg( _this->SimpleTouchHandler1.CurrentPos, _this->SimpleTouchHandler1.Offset ), 
  _this->Image1.Super1.Bounds.Point1 ), EwMovePointNeg( _this->SimpleTouchHandler1.CurrentPos, 
  _this->Image1.Super1.Bounds.Point1 ), clr, clr, 1 );
  EwNotifyObjObservers((XObject)&_this->Canvas1, 0 );
}

/* 'C' function for method : 'Application::Application.onDrag2()' */
void ApplicationApplication_onDrag2( ApplicationApplication _this, XObject sender )
{
  XColor clr;

  /* Dummy expressions to avoid the 'C' warning 'unused argument'. */
  EW_UNUSED_ARG( sender );

  clr = ApplicationMainColor;
  GraphicsCanvas_DrawLine( &_this->Canvas2, EwGetRectORect( _this->Image2.Super1.Bounds ), 
  EwMovePointNeg( EwMovePointNeg( _this->SimpleTouchHandler2.CurrentPos, _this->SimpleTouchHandler2.Offset ), 
  _this->Image2.Super1.Bounds.Point1 ), EwMovePointNeg( _this->SimpleTouchHandler2.CurrentPos, 
  _this->Image2.Super1.Bounds.Point1 ), clr, clr, 1 );
  EwNotifyObjObservers((XObject)&_this->Canvas2, 0 );
}

/* 'C' function for method : 'Application::Application.onDrag3()' */
void ApplicationApplication_onDrag3( ApplicationApplication _this, XObject sender )
{
  XColor clr;

  /* Dummy expressions to avoid the 'C' warning 'unused argument'. */
  EW_UNUSED_ARG( sender );

  clr = ApplicationMainColor;
  GraphicsCanvas_DrawLine( &_this->Canvas3, EwGetRectORect( _this->Image3.Super1.Bounds ), 
  EwMovePointNeg( EwMovePointNeg( _this->SimpleTouchHandler3.CurrentPos, _this->SimpleTouchHandler3.Offset ), 
  _this->Image3.Super1.Bounds.Point1 ), EwMovePointNeg( _this->SimpleTouchHandler3.CurrentPos, 
  _this->Image3.Super1.Bounds.Point1 ), clr, clr, 1 );
  EwNotifyObjObservers((XObject)&_this->Canvas3, 0 );
}

/* 'C' function for method : 'Application::Application.onDrag4()' */
void ApplicationApplication_onDrag4( ApplicationApplication _this, XObject sender )
{
  XColor clr;

  /* Dummy expressions to avoid the 'C' warning 'unused argument'. */
  EW_UNUSED_ARG( sender );

  clr = ApplicationMainColor;
  GraphicsCanvas_DrawLine( &_this->Canvas4, EwGetRectORect( _this->Image4.Super1.Bounds ), 
  EwMovePointNeg( EwMovePointNeg( _this->SimpleTouchHandler4.CurrentPos, _this->SimpleTouchHandler4.Offset ), 
  _this->Image4.Super1.Bounds.Point1 ), EwMovePointNeg( _this->SimpleTouchHandler4.CurrentPos, 
  _this->Image4.Super1.Bounds.Point1 ), clr, clr, 1 );
  EwNotifyObjObservers((XObject)&_this->Canvas4, 0 );
}

void ProcessInput( ApplicationApplication _this, int *input_code )
{
	XHandle tmp1;
	XHandle tmp2;
	XHandle tmp3;
	XHandle tmp4;
	XRect aArea1;
	XRect aArea2;
	XRect aArea3;
	XRect aArea4;
	XInt32 width;
	XInt32 height;

	tmp1 = _this->Canvas1.Super1.bitmap;
	tmp2 = _this->Canvas2.Super1.bitmap;
	tmp3 = _this->Canvas3.Super1.bitmap;
	tmp4 = _this->Canvas4.Super1.bitmap;

	aArea1 = EwGetRectORect( _this->Image1.Super1.Bounds );
	aArea2 = EwGetRectORect( _this->Image2.Super1.Bounds );
	aArea3 = EwGetRectORect( _this->Image3.Super1.Bounds );
	aArea4 = EwGetRectORect( _this->Image4.Super1.Bounds );

	width = aArea1.Point2.X - aArea1.Point1.X;
	height = aArea1.Point2.Y - aArea1.Point1.Y;

	XBitmap* bitmap1 = (XBitmap*)tmp1;
	XBitmap* bitmap2 = (XBitmap*)tmp2;
	XBitmap* bitmap3 = (XBitmap*)tmp3;
	XBitmap* bitmap4 = (XBitmap*)tmp4;

	/* The color is stored in an embedded wizard structure and needs to be converted
	   into an integer so that it can be compared to the stored color values
	   in the memory. The stored color format is 0xAARRGGBB, where A stands for Alpha,
	   R for red, G for green and B for blue. */
	uint32_t drawing_colorINT = ((uint32_t) ApplicationMainColor.Alpha) << 24 |((uint32_t) ApplicationMainColor.Red) << 16 | ((uint32_t) ApplicationMainColor.Green) << 8 | ((uint32_t) ApplicationMainColor.Blue);

	XBitmapLock* lock1 = EwLockBitmap(bitmap1, 0, aArea1, 1, 0);
	XBitmapLock* lock2 = EwLockBitmap(bitmap2, 0, aArea2, 1, 0);
	XBitmapLock* lock3 = EwLockBitmap(bitmap3, 0, aArea3, 1, 0);
	XBitmapLock* lock4 = EwLockBitmap(bitmap4, 0, aArea4, 1, 0);

	uint32_t* src1   = (uint32_t*)lock1->Pixel1;
	uint32_t* src2   = (uint32_t*)lock2->Pixel1;
	uint32_t* src3   = (uint32_t*)lock3->Pixel1;
	uint32_t* src4   = (uint32_t*)lock4->Pixel1;

	int ofs1 = ( lock1->Pitch1Y / 4 ) - width; // offset between rows (to skip irrelevant pixels on each row)
	int ofs2 = ( lock2->Pitch1Y / 4 ) - width;
	int ofs3 = ( lock3->Pitch1Y / 4 ) - width;
	int ofs4 = ( lock4->Pitch1Y / 4 ) - width;

	uint8_t *bmp1 = (uint8_t*) malloc(sizeof(uint8_t) * width * height);
	uint8_t *bmp2 = (uint8_t*) malloc(sizeof(uint8_t) * width * height);
	uint8_t *bmp3 = (uint8_t*) malloc(sizeof(uint8_t) * width * height);
	uint8_t *bmp4 = (uint8_t*) malloc(sizeof(uint8_t) * width * height);

	if (bmp1 == NULL || bmp2 == NULL || bmp3 == NULL || bmp4 == NULL)
	{
		EwPrint("Out of memory!\n\r");
		return;
	}

	for (int i = 0; i < width * height; i++)
	{
		bmp1[i] = 0;
		bmp2[i] = 0;
		bmp3[i] = 0;
		bmp4[i] = 0;
	}

	for (int y = 0; y < height; y++, src1 += ofs1, src2 += ofs2, src3 += ofs3, src4 += ofs4 )
	{
		for (int x = 0; x < width; x++, src1++, src2++, src3++, src4++ )
		{
			/* <drawing_color> colored pixels get stored as 0xFF bytes forming + signs with ADD_PIXELS long lines,
			 in order to thicken the drawn digit so that the pixels aren't lost when the picture is resized.
			 All the other pixels are stored as 0x00. Since the MNIST dataset contains single-channel
			 greyscale images, feeding the trained model single-channel black and white images
			 created this way works as well. */
			if (*src1 == drawing_colorINT)
			{
				for (int i = -(ADD_PIXELS/2); i <= ADD_PIXELS/2; i++ )
				{
					if ((x + i) > 0 && (x + i) < width)
						bmp1[(x + i) + (y * width)] = 0xFF;
					if ((y + i) > 0 && (y + i) < height)
						bmp1[x + ((y + i) * width)] = 0xFF;
				}
			}

			if (*src2 == drawing_colorINT)
			{
				for (int i = -(ADD_PIXELS/2); i <= ADD_PIXELS/2; i++ )
				{
					if ((x + i) > 0 && (x + i) < width)
						bmp2[(x + i) + (y * width)] = 0xFF;
					if ((y + i) > 0 && (y + i) < height)
						bmp2[x + ((y + i) * width)] = 0xFF;
				}
			}

			if (*src3 == drawing_colorINT)
			{
				for (int i = -(ADD_PIXELS/2); i <= ADD_PIXELS/2; i++ )
				{
					if ((x + i) > 0 && (x + i) < width)
						bmp3[(x + i) + (y * width)] = 0xFF;
					if ((y + i) > 0 && (y + i) < height)
						bmp3[x + ((y + i) * width)] = 0xFF;
				}
			}

			if (*src4 == drawing_colorINT)
			{
				for (int i = -(ADD_PIXELS/2); i <= ADD_PIXELS/2; i++ )
				{
					if ((x + i) > 0 && (x + i) < width)
						bmp4[(x + i) + (y * width)] = 0xFF;
					if ((y + i) > 0 && (y + i) < height)
						bmp4[x + ((y + i) * width)] = 0xFF;
				}
			}
		}
	}


	input_code[0] = MODEL_ClassifyInput(bmp1, width, height);
	input_code[1] = MODEL_ClassifyInput(bmp2, width, height);
	input_code[2] = MODEL_ClassifyInput(bmp3, width, height);
	input_code[3] = MODEL_ClassifyInput(bmp4, width, height);

	free(bmp1);
	free(bmp2);
	free(bmp3);
	free(bmp4);

	EwUnlockBitmap(lock1);
	EwUnlockBitmap(lock2);
	EwUnlockBitmap(lock3);
	EwUnlockBitmap(lock4);
}

/* 'C' function for method : 'Application::Application.onPressClearScreen()' */
void ApplicationApplication_onPressClearScreen( ApplicationApplication _this, XObject 
  sender )
{
  /* Dummy expressions to avoid the 'C' warning 'unused argument'. */
  EW_UNUSED_ARG( sender );

  GraphicsCanvas_FillRectangle( &_this->Canvas1, EwGetRectORect( _this->Image1.Super1.Bounds ), 
  EwGetRectORect( _this->Image1.Super1.Bounds ), ApplicationBackgroundColor, ApplicationBackgroundColor, 
  ApplicationBackgroundColor, ApplicationBackgroundColor, 0 );
  GraphicsCanvas_FillRectangle( &_this->Canvas2, EwGetRectORect( _this->Image2.Super1.Bounds ), 
  EwGetRectORect( _this->Image2.Super1.Bounds ), ApplicationBackgroundColor, ApplicationBackgroundColor, 
  ApplicationBackgroundColor, ApplicationBackgroundColor, 0 );
  GraphicsCanvas_FillRectangle( &_this->Canvas3, EwGetRectORect( _this->Image3.Super1.Bounds ), 
  EwGetRectORect( _this->Image3.Super1.Bounds ), ApplicationBackgroundColor, ApplicationBackgroundColor, 
  ApplicationBackgroundColor, ApplicationBackgroundColor, 0 );
  GraphicsCanvas_FillRectangle( &_this->Canvas4, EwGetRectORect( _this->Image4.Super1.Bounds ), 
  EwGetRectORect( _this->Image4.Super1.Bounds ), ApplicationBackgroundColor, ApplicationBackgroundColor, 
  ApplicationBackgroundColor, ApplicationBackgroundColor, 0 );
  CoreGroup__InvalidateArea( _this, _this->Image1.Super1.Bounds );
  CoreGroup__InvalidateArea( _this, _this->Image2.Super1.Bounds );
  CoreGroup__InvalidateArea( _this, _this->Image3.Super1.Bounds );
  CoreGroup__InvalidateArea( _this, _this->Image4.Super1.Bounds );

	ViewsBorder_OnSetColor( &_this->Border1, ApplicationMainColor );
	ViewsBorder_OnSetColor( &_this->Border2, ApplicationMainColor );
	ViewsBorder_OnSetColor( &_this->Border3, ApplicationMainColor );
	ViewsBorder_OnSetColor( &_this->Border4, ApplicationMainColor );

  ViewsText_OnSetString( &_this->InfoText, 0 );
  ViewsText_OnSetString( &_this->ResultsText, 0 );
}

/* 'C' function for method : 'Application::Application.onPressSetPassword()' */
void ApplicationApplication_onPressSetPassword( ApplicationApplication _this, XObject 
  sender )
{
  XString okStr;

  /* Dummy expressions to avoid the 'C' warning 'unused argument'. */
  EW_UNUSED_ARG( _this );
  EW_UNUSED_ARG( sender );

  okStr = EwLoadString( &ApplicationOKString );

	ProcessInput( _this, password );

	char input_code_string[5];
	for (int i = 0; i < 4; i++ )
	{
		input_code_string[i] = (char) (password[i] + 48); // 48 is the ASCII decimal value of 0
	}
	input_code_string[4] = '\0';

	/* Printing out the result into the result area */
	ViewsText_OnSetString(&_this->ResultsText, EwNewStringAnsi(input_code_string));
	ViewsText_OnSetString( &_this->InfoText, okStr);
	ViewsText_OnSetColor( &_this->InfoText, ApplicationMainColor );
	ViewsText_OnSetColor( &_this->InfoText, ApplicationMainColor );
	ViewsBorder_OnSetColor( &_this->Border1, ApplicationMainColor );
	ViewsBorder_OnSetColor( &_this->Border2, ApplicationMainColor );
	ViewsBorder_OnSetColor( &_this->Border3, ApplicationMainColor );
	ViewsBorder_OnSetColor( &_this->Border4, ApplicationMainColor );
}

/* 'C' function for method : 'Application::Application.onPressLock()' */
void ApplicationApplication_onPressLock( ApplicationApplication _this, XObject sender )
{
  XColor correctClr;
  XColor wrongClr;
  XString lockStr;
  XString unlockStr;
  XString correctStr;
  XString wrongStr;

  /* Dummy expressions to avoid the 'C' warning 'unused argument'. */
  EW_UNUSED_ARG( _this );
  EW_UNUSED_ARG( sender );

  correctClr = ApplicationCorrectColor;
  wrongClr = ApplicationWrongColor;
  lockStr = EwLoadString( &ApplicationLockString );
  unlockStr = EwLoadString( &ApplicationUnlockString );
  correctStr = EwLoadString( &ApplicationCorrectString );
  wrongStr = EwLoadString( &ApplicationWrongString );

	if (!locked)
	{
		locked = 1;
		ViewsText_OnSetString( &_this->InfoText, 0 );
		ViewsText_OnSetString( &_this->ResultsText, 0 );
		WidgetSetPushButton_OnSetLabel( &_this->LockButton, unlockStr);
		ViewsBorder_OnSetColor( &_this->Border1, wrongClr );
		ViewsBorder_OnSetColor( &_this->Border2, wrongClr );
		ViewsBorder_OnSetColor( &_this->Border3, wrongClr );
		ViewsBorder_OnSetColor( &_this->Border4, wrongClr );
		return;
	}


	{
		int input_code[4];
		ProcessInput( _this, input_code );

		char input_code_string[5];
		int correct = 1;
		for (int i = 0; i < 4; i++ )
		{
			if (!(input_code[i] == password[i]))
			{
				correct = 0;
			}

			input_code_string[i] = (char) (input_code[i] + 48); // 48 is the ASCII decimal value of 0
		}
		input_code_string[4] = '\0';


		/* Printing out the result into the result area */
		ViewsText_OnSetString(&_this->ResultsText, EwNewStringAnsi(input_code_string));

		if (correct)
		{
			ViewsText_OnSetString( &_this->InfoText, correctStr);
			ViewsText_OnSetColor( &_this->InfoText, correctClr );
			locked = 0;
			WidgetSetPushButton_OnSetLabel( &_this->LockButton, lockStr);
			ViewsBorder_OnSetColor( &_this->Border1, correctClr );
			ViewsBorder_OnSetColor( &_this->Border2, correctClr );
			ViewsBorder_OnSetColor( &_this->Border3, correctClr );
			ViewsBorder_OnSetColor( &_this->Border4, correctClr );
		}
		else
		{
			ViewsText_OnSetString( &_this->InfoText, wrongStr);
			ViewsText_OnSetColor( &_this->InfoText, wrongClr );
			ViewsBorder_OnSetColor( &_this->Border1, wrongClr );
			ViewsBorder_OnSetColor( &_this->Border2, wrongClr );
			ViewsBorder_OnSetColor( &_this->Border3, wrongClr );
			ViewsBorder_OnSetColor( &_this->Border4, wrongClr );
		}
	}
}

/* 'C' function for method : 'Application::Application.onPressClear1()' */
void ApplicationApplication_onPressClear1( ApplicationApplication _this, XObject 
  sender )
{
  /* Dummy expressions to avoid the 'C' warning 'unused argument'. */
  EW_UNUSED_ARG( sender );

  GraphicsCanvas_FillRectangle( &_this->Canvas1, EwGetRectORect( _this->Image1.Super1.Bounds ), 
  EwGetRectORect( _this->Image1.Super1.Bounds ), ApplicationBackgroundColor, ApplicationBackgroundColor, 
  ApplicationBackgroundColor, ApplicationBackgroundColor, 0 );
  ViewsBorder_OnSetColor( &_this->Border1, ApplicationMainColor );
  CoreGroup__InvalidateArea( _this, _this->Image1.Super1.Bounds );
}

/* 'C' function for method : 'Application::Application.onPressClear2()' */
void ApplicationApplication_onPressClear2( ApplicationApplication _this, XObject 
  sender )
{
  /* Dummy expressions to avoid the 'C' warning 'unused argument'. */
  EW_UNUSED_ARG( sender );

  GraphicsCanvas_FillRectangle( &_this->Canvas2, EwGetRectORect( _this->Image2.Super1.Bounds ), 
  EwGetRectORect( _this->Image2.Super1.Bounds ), ApplicationBackgroundColor, ApplicationBackgroundColor, 
  ApplicationBackgroundColor, ApplicationBackgroundColor, 0 );
  ViewsBorder_OnSetColor( &_this->Border2, ApplicationMainColor );
  CoreGroup__InvalidateArea( _this, _this->Image2.Super1.Bounds );
}

/* 'C' function for method : 'Application::Application.onPressClear3()' */
void ApplicationApplication_onPressClear3( ApplicationApplication _this, XObject 
  sender )
{
  /* Dummy expressions to avoid the 'C' warning 'unused argument'. */
  EW_UNUSED_ARG( sender );

  GraphicsCanvas_FillRectangle( &_this->Canvas3, EwGetRectORect( _this->Image3.Super1.Bounds ), 
  EwGetRectORect( _this->Image3.Super1.Bounds ), ApplicationBackgroundColor, ApplicationBackgroundColor, 
  ApplicationBackgroundColor, ApplicationBackgroundColor, 0 );
  ViewsBorder_OnSetColor( &_this->Border3, ApplicationMainColor );
  CoreGroup__InvalidateArea( _this, _this->Image3.Super1.Bounds );
}

/* 'C' function for method : 'Application::Application.onPressClear4()' */
void ApplicationApplication_onPressClear4( ApplicationApplication _this, XObject 
  sender )
{
  /* Dummy expressions to avoid the 'C' warning 'unused argument'. */
  EW_UNUSED_ARG( sender );

  GraphicsCanvas_FillRectangle( &_this->Canvas4, EwGetRectORect( _this->Image4.Super1.Bounds ), 
  EwGetRectORect( _this->Image4.Super1.Bounds ), ApplicationBackgroundColor, ApplicationBackgroundColor, 
  ApplicationBackgroundColor, ApplicationBackgroundColor, 0 );
  ViewsBorder_OnSetColor( &_this->Border4, ApplicationMainColor );
  CoreGroup__InvalidateArea( _this, _this->Image4.Super1.Bounds );
}

/* Variants derived from the class : 'Application::Application' */
EW_DEFINE_CLASS_VARIANTS( ApplicationApplication )
EW_END_OF_CLASS_VARIANTS( ApplicationApplication )

/* Virtual Method Table (VMT) for the class : 'Application::Application' */
EW_DEFINE_CLASS( ApplicationApplication, CoreRoot, Rectangle, Rectangle, Rectangle, 
                 Rectangle, _.VMT, _.VMT, "Application::Application" )
  CoreRectView_initLayoutContext,
  CoreRoot_GetRoot,
  CoreRoot_Draw,
  CoreView_HandleEvent,
  CoreGroup_CursorHitTest,
  CoreRectView_ArrangeView,
  CoreRectView_MoveView,
  CoreRectView_GetExtent,
  CoreRoot_ChangeViewState,
  CoreGroup_OnSetBounds,
  CoreRoot_OnSetFocus,
  CoreRoot_DispatchEvent,
  CoreRoot_BroadcastEvent,
  CoreGroup_UpdateViewState,
  CoreRoot_InvalidateArea,
EW_END_OF_CLASS( ApplicationApplication )

/* User defined constant: 'Application::LockString' */
const XStringRes ApplicationLockString = { _StringsDefault0, 0x0002 };

/* User defined constant: 'Application::UnlockString' */
const XStringRes ApplicationUnlockString = { _StringsDefault0, 0x0009 };

/* User defined constant: 'Application::WrongString' */
const XStringRes ApplicationWrongString = { _StringsDefault0, 0x0012 };

/* User defined constant: 'Application::CorrectString' */
const XStringRes ApplicationCorrectString = { _StringsDefault0, 0x001A };

/* User defined constant: 'Application::WrongColor' */
const XColor ApplicationWrongColor = { 0xFF, 0x00, 0x00, 0xFF };

/* User defined constant: 'Application::CorrectColor' */
const XColor ApplicationCorrectColor = { 0x00, 0xFF, 0x00, 0xFF };

/* User defined constant: 'Application::MainColor' */
const XColor ApplicationMainColor = { 0xFF, 0xFF, 0xFF, 0xFF };

/* User defined constant: 'Application::BackgroundColor' */
const XColor ApplicationBackgroundColor = { 0x00, 0x00, 0x00, 0xFF };

/* User defined constant: 'Application::OKString' */
const XStringRes ApplicationOKString = { _StringsDefault0, 0x0024 };

/* Embedded Wizard */
