/*
 * Copyright 2021 NXP
 * All rights reserved.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 */

#include "tensorflow/lite/micro/kernels/micro_ops.h"
#include "tensorflow/lite/micro/micro_mutable_op_resolver.h"

tflite::MicroOpResolver &MODEL_GetOpsResolver(tflite::ErrorReporter* errorReporter)
{
    static tflite::MicroMutableOpResolver<7> s_microOpResolver(errorReporter);

    s_microOpResolver.AddMaxPool2D();
    s_microOpResolver.AddConv2D();
    s_microOpResolver.AddFullyConnected();
    s_microOpResolver.AddQuantize();
    s_microOpResolver.AddDequantize();
    s_microOpResolver.AddReshape();
    s_microOpResolver.AddSoftmax();

    return s_microOpResolver;
}
