/*
 * Copyright 2020-2021 NXP
 * All rights reserved.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 */

#include "model.h"

#include "ewmain.h"
#include "ewrte.h"
#include "ew_bsp_system.h"
#include "ew_bsp_console.h"
int main(void)
{
	 /* initialize system */


	EwBspSystemInit();

	/* initialize console interface for debug messages */
	EwBspConsoleInit();

	/* initialize Embedded Wizard application */
	if ( EwInit() == 0 )
	  return 1;

	if (MODEL_Init() != kStatus_Success)
	{
		EwPrint("Failed initializing model\n");
		for (;;) {}
	}

	EwPrintSystemInfo();

	/* process the Embedded Wizard main loop */
	while( EwProcess())
	  ;

	/* de-initialize Embedded Wizard application */
	EwDone();

	/* restore console */
	EwBspConsoleDone();

	/* terminate the system */
	EwBspSystemDone();

	return 0;

}
