/*
 * Copyright (c) 2017 - 2018 , NXP
 * All rights reserved.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 */

#ifndef __APP_H__
#define __APP_H__

// C Standard Lib includes
#include <stdbool.h>
#include <stdlib.h>
#include <stdio.h>
#include <stdint.h>

// LPC55xx Chip peripherals & Boards includes

#include "fsl_common.h"
#include "fsl_clock.h"
#include "fsl_gpio.h"
#include "fsl_usart.h"
#include "fsl_iocon.h"

#include "fsl_common.h"
#include "fsl_iocon.h"

#include "lpc_ring_buffer.h"

#include "app_printf.h"
#include "app_led.h"

#include "clock_config.h"

/* Component headers, NTSHELL */
#include "ntshell.h"
#include "usrcmd.h"

extern volatile uint32_t g_SysTicks;

/*******************************************************************************
 * Definitions
 ******************************************************************************/

#define BOARD_NAME                 "LPCXpresso5500"

/* SystemTick Settings */
#define OSINTERVAL                 1000
#define SLEEPTIME                  10

/* Debug USART port */
#define DEBUG_ENABLE               1

#define DEBUG_UART                 USART0
#define DEBUG_UART_TYPE            kSerialPort_Uart

#define DEBUG_UART_CLKFREQ         12000000U
#define DEBUG_UART_CLKATTACH       kFRO12M_to_FLEXCOMM0
#define DEBUG_UART_RST             kFC0_RST_SHIFT_RSTn
#define DEBUG_UART_CLKSRC          kCLOCK_Flexcomm0
#define DEBUG_UART_IRQHANDLER      FLEXCOMM0_IRQHandler
#define DEBUG_UART_IRQNUM          FLEXCOMM0_IRQn
#define DEBUG_UART_BAUDRATE        115200U

#define DEBUG_BUFFER_SIZE          200   /* Debug Uart Buffer Length */

#define DEBUGTX_PORT               0u
#define DEBUGTX_PIN                30u
#define DEBUGTX_FUNC               (IOCON_FUNC1 | IOCON_MODE_INACT | IOCON_DIGITAL_EN)

#define DEBUGRX_PORT               0u
#define DEBUGRX_PIN                29u
#define DEBUGRX_FUNC               (IOCON_FUNC1 | IOCON_MODE_INACT | IOCON_DIGITAL_EN)

#define LEDR_PORT                  1u
#define LEDR_PIN                   6u
#define LEDR_FUNC                  (IOCON_FUNC0 | IOCON_MODE_INACT | IOCON_DIGITAL_EN)

#define LEDG_PORT                  1u
#define LEDG_PIN                   7u
#define LEDG_FUNC                  (IOCON_FUNC0 | IOCON_MODE_INACT | IOCON_DIGITAL_EN)

#define LEDB_PORT                  1u
#define LEDB_PIN                   4u
#define LEDB_FUNC                  (IOCON_FUNC0 | IOCON_MODE_INACT | IOCON_DIGITAL_EN)

#endif
