/*!
 * Copyright 2016-2017 NXP
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *
 * o Redistributions of source code must retain the above copyright notice, this list
 *   of conditions and the following disclaimer.
 *
 * o Redistributions in binary form must reproduce the above copyright notice, this
 *   list of conditions and the following disclaimer in the documentation and/or
 *   other materials provided with the distribution.
 *
 * o Neither the name of Freescale Semiconductor, Inc. nor the names of its
 *   contributors may be used to endorse or promote products derived from this
 *   software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 * ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#include "genfsk_interface_qn.h"
#include "genfsk_ll_qn.h"
#include "genfsk_utils_qn.h"
#include "fsl_prop.h"
#include "fsl_os_abstraction.h"

/*******************************************************************************
 * Variables
 ******************************************************************************/
extern GENFSK_LocalStruct_t genfskLocal[];
extern uint8_t mGenfskActiveInstance;
extern uint32_t SystemCoreClock;

/*******************************************************************************
 * Code
 ******************************************************************************/
void GENFSK_WritePacketBuffer(uint16_t addr_offset, uint8_t *buffer, uint16_t length)
{
    uint8_t *pTemp = NULL;
    uint16_t count = 0;
    
    pTemp = (uint8_t *)(PACKET_BUFFER_BASE_ADDR + addr_offset);
    
    for (count = 0; count < length; count++)
    {
        pTemp[count] = buffer[count];
    }
}
        
void GENFSK_ReadPacketBuffer(uint16_t addr_offset, uint8_t *buffer, uint16_t length)
{
    uint8_t *pTemp = NULL;
    uint16_t count = 0;
    
    pTemp = (uint8_t *)(PACKET_BUFFER_BASE_ADDR + addr_offset);
    
    for (count = 0; count < length; count++)
    {        
        buffer[count] = pTemp[count];
    }
}

uint16_t GENFSK_Reverse9Bit(uint16_t input)
{    
    uint16_t output;
    
    output = (((input & 0x1) << 8) | ((input & 0x100) >> 8));
    output |= ((input & 0x2) << 6) | ((input & 0x80) >> 6);
    output |= ((input & 0x4) << 4) | ((input & 0x40) >> 4);
    output |= ((input & 0x8) << 2) | ((input & 0x20) >> 2);
    output |= (input & 0x10);
    return output;
}

void GENFSK_SwitchToInstance(uint8_t instanceId)
{
    prop_radio_mode_t radioMode = kPROP_RadioModeBt0p5h0p5;
    
    OSA_InterruptDisable();    

     switch (genfskLocal[instanceId].radioConfig.radioMode)
     {
      case gGenfskGfskBt0p5h0p5:
          radioMode = kPROP_RadioModeBt0p5h0p5;
          break;
      case gGenfskGfskBt0p5h0p32:
          radioMode = kPROP_RadioModeBt0p5h0p32;
          break;
      case gGenfskGfskBt0p5h0p7:
          radioMode = kPROP_RadioModeBt0p5h0p7;
          break;
      default:
          radioMode = kPROP_RadioModeBt0p5h0p5;
          break;
     }
        
    PROP_RadioConfig(PROP, radioMode, (prop_data_rate_t)genfskLocal[instanceId].radioConfig.dataRate);
    
    OSA_InterruptEnable();
}

void GENFSK_MskPreProcessing(uint8_t * pByteIn, uint8_t * pByteOut, uint8_t length, uint8_t initBit)
{  
    uint8_t temp = 0x00;
    uint8_t tempByteOut = 0x00;
    uint8_t tempByteIn;
    temp = initBit;
    
    for (uint8_t i = 0; i < length; i++)
    {
        tempByteIn = *(pByteIn++);
        temp |= (tempByteIn << 1);
        tempByteOut = tempByteIn ^ temp;
        tempByteOut ^= 0xAA;
        temp = tempByteIn >> 7;
        *(pByteOut++) = tempByteOut;
    }
}

void GENFSK_MskPostProcessing(uint8_t * pByteIn, uint8_t * pByteOut, uint8_t length, uint8_t initBit, uint8_t lsbToMsb)
{
    uint8_t temp = 0x00;
    uint8_t tempByteOut = 0x00;
    uint8_t byteInMask = 0x00;
    uint8_t tempByteIn = 0x00;
    
    temp = initBit;
    
    for (uint8_t k = 0; k < length; k++)
    {
        tempByteIn = *(pByteIn++);
        if (!lsbToMsb)
        {
            /* Reflect byte */
            tempByteIn = (tempByteIn >> 4) | (tempByteIn << 4);
            tempByteIn = ((tempByteIn & 0xCC) >> 2) | ((tempByteIn & 0x33) << 2);
            tempByteIn = ((tempByteIn & 0xAA) >> 1) | ((tempByteIn & 0x55) << 1);
        }
        
        byteInMask = tempByteIn ^ 0xAA;
        
        for (uint32_t i = 0; i < 8; i++)
        {
            tempByteOut = byteInMask ^ temp;
            temp ^= (tempByteOut << 1);
        }
            
        temp = tempByteOut >> 7;
        
        if (!lsbToMsb)
        {
            /* Reflect byte */
            tempByteOut = (tempByteOut >> 4) | (tempByteOut << 4);
            tempByteOut = ((tempByteOut & 0xCC) >> 2) | ((tempByteOut & 0x33) << 2);
            tempByteOut = ((tempByteOut & 0xAA) >> 1) | ((tempByteOut & 0x55) << 1);
        }    
        *(pByteOut++) = tempByteOut;
    }
}

void GENFSK_SwapBytes(uint8_t * pByteIn, uint8_t * pByteOut, uint8_t length)
{
    uint8_t tempByteOut = 0x00;
    
    for (uint32_t k=0; k<length; k++)
    {
        tempByteOut = *(pByteIn++);
        /* Reflect byte */
        tempByteOut = (tempByteOut >> 4) | (tempByteOut << 4);
        tempByteOut = ((tempByteOut & 0xCC) >> 2) | ((tempByteOut & 0x33) << 2);
        tempByteOut = ((tempByteOut & 0xAA) >> 1) | ((tempByteOut & 0x55) << 1);
        *(pByteOut++) = tempByteOut;
    }
}
