/*!
 * Copyright 2016-2017 NXP
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *
 * o Redistributions of source code must retain the above copyright notice, this list
 *   of conditions and the following disclaimer.
 *
 * o Redistributions in binary form must reproduce the above copyright notice, this
 *   list of conditions and the following disclaimer in the documentation and/or
 *   other materials provided with the distribution.
 *
 * o Neither the name of Freescale Semiconductor, Inc. nor the names of its
 *   contributors may be used to endorse or promote products derived from this
 *   software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 * ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef _GENFSK_LL_H_
#define _GENFSK_LL_H_

#include "EmbeddedTypes.h"
#include "fsl_common.h"

/*!
 * @addtogroup genfsk_ll
 * @{
 */

/*! @file */

/*******************************************************************************
 * Definitions
 ******************************************************************************/
/*! @brief GENFSK Timer invalid ID. */
#define gGENFSK_InvalidTimerId_c          (0xFF)
/*! @brief GENFSK Timer guard time in microseconds. */
#define gGENFSK_MinSetupTime_c            (20)

#define gGENFSK_DMA_IsrPrio_c (0x80)
/*!
 * @brief GENFSK interrupts definition.
 *
 * Definition of the interrupts available in GENFSK LL.
 */

/*! @brief GENFSK LL internal states. */
typedef enum _GENFSK_LL_state
{    
    gGENFSK_LL_NoInit = 0U,
    gGENFSK_LL_Idle = 1U,
    gGENFSK_LL_BusyRx = 2U,
    gGENFSK_LL_BusyTx = 3U,
    gGENFSK_LL_BusyPendingRx = 4U,
    gGENFSK_LL_BusyPendingTx = 5U
} GENFSK_LL_state_t;

/*! @brief GENFSK LL task event flags. */ 
typedef enum
{
    gGenfskTxDmaEventFlag_c = (1<<0),
    gGenfskRxDmaEventFlag_c = (1<<1)
}GENFSK_LL_event_flags_t;

/*! @brief GENFSK timeout callback. */
typedef void (*genfskTimeCallback_t) (void);

/*! @brief GENFSK timer ID type. */
typedef uint8_t genfskTimerId_t;

/*! @brief GENFSK time structure. */
typedef struct _GENFSK_TimeEvent
{
    GENFSK_timestamp_t    timestamp;
    genfskTimeCallback_t  callback;
} GENFSK_TimeEvent_t;

/*! @brief GENFSK RX local structure. */
typedef struct _GENFSK_RxLocalStruct
{
    uint8_t *rxPacketBuffer;
    uint16_t rxMaxPacketLength;
} GENFSK_RxLocalStruct_t;

/*! @brief GENFSK saved registers structure.*/
typedef struct _GENFSK_RegsStruct
{
    uint32_t irqCtrl;
    uint32_t xcvrCtrl;
    uint32_t xcvrCfg;
    uint32_t channelNum;
    uint32_t txPower;
    uint32_t ntwAdrCtrl;
    uint32_t ntwAdr0;
    uint32_t ntwAdr1;
    uint32_t ntwAdr2;
    uint32_t ntwAdr3;
    uint32_t packetCfg;
    uint32_t crcCfg;
    uint32_t crcInit;
    uint32_t crcPoly;
    uint32_t bitRate;  
} GENFSK_RegsStruct_t;

/*! @brief GENFSK local structure. */
typedef struct _GENFSK_LocalStruct
{
    GENFSK_LL_state_t genfskState;
    GENFSK_RxLocalStruct_t genfskRxLocal;
    GENFSK_radio_config_t radioConfig;
    GENFSK_packet_config_t packetConfig;
    GENFSK_channel_config_t channelNumberConfig;    
    uint8_t syncAddrSizeBytes;
    genfskCrcComputeMode_t crcEnable;
    genfskCrcRecvInvalid_t crcRecvInvalid;
    genfskPacketReceivedCallBack_t packetReceivedcallback;
    genfskEventNotifyCallBack_t eventNotifyCallback;
    uint32_t enabledEvents;
} GENFSK_LocalStruct_t;

/*! @brief GENFSK instance status. */
typedef uint8_t GENFSK_InstanceStatus_t;

/*! @} */

#endif /* _GENFSK_LL_H_ */
