#include "fsl_os_abstraction.h"
#include "HAL_timer_driver.h"
#include "fsl_common.h"



/***********************************************************************/
/* GLOBAL VARIABLES                                                    */
/***********************************************************************/
static volatile uint32_t timer = 0;


void HAL_Timer_Init(void)
{
    /* produce a timer interrupt every 1ms */
    SysTick_Config(SystemCoreClock / 1000);
}

void HAL_Timer_delay_ms(uint32_t ms)
{
    if( USE_RTOS == 0 )
    {
        OSA_TimeDelay( ms );
    }
    else
    {
        OSA_TimeDelay( ms * 6 );		
    }

}

uint32_t HAL_Timer_getTime_ms(void)
{
    return OSA_TimeGetMsec();
}

/***********************************************************************/
/* LOCAL FUNCTIONS                                                     */
/***********************************************************************/
/***********************************************************************/
/* INTERUPT SERVICE ROUTINES                                           */
/***********************************************************************/
//void SysTick_Handler(void)
//{
//    timer++;
//}

