/*
 * Copyright (c) 2016, Freescale Semiconductor, Inc.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *
 * o Redistributions of source code must retain the above copyright notice, this list
 *   of conditions and the following disclaimer.
 *
 * o Redistributions in binary form must reproduce the above copyright notice, this
 *   list of conditions and the following disclaimer in the documentation and/or
 *   other materials provided with the distribution.
 *
 * o Neither the name of Freescale Semiconductor, Inc. nor the names of its
 *   contributors may be used to endorse or promote products derived from this
 *   software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 * ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
 
#include "fsl_prop.h"



void PROP_Init(PROP_Type *base)
{
    /* Enable prop module clock*/
    CLOCK_EnableClock(kCLOCK_Prop);
  
    /* Configure datapath used as prop */
    /* Rx mode: '11' means prop mode, '00' means ble mode */
    /* Tx En select: '1' means user programmed, '0' means from ble ip */
    /* Rx En select: '1' means user programmed, '0' means from ble ip */
    /* H index select:  */
    /* PDU Len select: '1' means user programmed, '0' means from ble ip */
    /* AA select: '1' means user programmed, '0' means from ble ip */
    BLEDP->DP_TOP_SYSTEM_CTRL = (BLEDP_DP_TOP_SYSTEM_CTRL_RX_MODE(3)
                                 | BLEDP_DP_TOP_SYSTEM_CTRL_TX_EN_SEL(1) 
                                 | BLEDP_DP_TOP_SYSTEM_CTRL_RX_EN_SEL(1) 
                                 | BLEDP_DP_TOP_SYSTEM_CTRL_H_IDX(0x80)
                                 | BLEDP_DP_TOP_SYSTEM_CTRL_PDU_LEN_SEL(1)
                                 | BLEDP_DP_TOP_SYSTEM_CTRL_AA_SEL(1));
}


void PROP_DeInit(PROP_Type *base)
{
    /* Disable Tx request */
    PROP_StopTx(base);
    /* Disable Rx request */
    PROP_StopRx(base);
    /* Configure datapath used as default */
     /* Rx mode: '00' means ble mode */
    /* Tx En select: '0' means from ble ip */
    /* Rx En select: '0' means from ble ip */
    /* PDU Len select: '0' means from ble ip */
    /* AA select: '0' means from ble ip */
    BLEDP->DP_TOP_SYSTEM_CTRL = (BLEDP_DP_TOP_SYSTEM_CTRL_RX_MODE(0)
                                 | BLEDP_DP_TOP_SYSTEM_CTRL_TX_EN_SEL(0)
                                 | BLEDP_DP_TOP_SYSTEM_CTRL_RX_EN_SEL(0)
                                 | BLEDP_DP_TOP_SYSTEM_CTRL_PDU_LEN_SEL(0)
                                 | BLEDP_DP_TOP_SYSTEM_CTRL_AA_SEL(0));
  
    /* Disable prop module clock*/
    CLOCK_DisableClock(kCLOCK_Prop); 

    /* disable LO configure by mannual */
    CALIB->LO_CFG &= ~CALIB_LO_CFG_LO_SEL_MASK;
    /* disable HOP configure by mannual */
    CALIB->CTRL &= ~CALIB_CTRL_HOP_CLB_SEL_MASK;    
}


void PROP_StartTx(PROP_Type *base)
{
    BLEDP->DP_TOP_SYSTEM_CTRL = (BLEDP->DP_TOP_SYSTEM_CTRL & ~BLEDP_DP_TOP_SYSTEM_CTRL_TX_REQ_MASK)
                                | BLEDP_DP_TOP_SYSTEM_CTRL_TX_REQ(0);
    BLEDP->DP_TOP_SYSTEM_CTRL = (BLEDP->DP_TOP_SYSTEM_CTRL & ~BLEDP_DP_TOP_SYSTEM_CTRL_TX_REQ_MASK)
                                | BLEDP_DP_TOP_SYSTEM_CTRL_TX_REQ(1);
    PROP->STAT = (PROP->STAT & ~PROP_STAT_CLR_MASK) | PROP_STAT_CLR(1);
    PROP->STAT = (PROP->STAT & ~PROP_STAT_CLR_MASK) | PROP_STAT_CLR(0);
}


void PROP_StartRx(PROP_Type *base)
{
    BLEDP->DP_TOP_SYSTEM_CTRL = (BLEDP->DP_TOP_SYSTEM_CTRL & ~BLEDP_DP_TOP_SYSTEM_CTRL_RX_REQ_MASK)
                                | BLEDP_DP_TOP_SYSTEM_CTRL_RX_REQ(0);
    BLEDP->DP_TOP_SYSTEM_CTRL = (BLEDP->DP_TOP_SYSTEM_CTRL & ~BLEDP_DP_TOP_SYSTEM_CTRL_RX_REQ_MASK)
                                | BLEDP_DP_TOP_SYSTEM_CTRL_RX_REQ(1);
    PROP->STAT = (PROP->STAT & ~PROP_STAT_CLR_MASK) | PROP_STAT_CLR(1);
    PROP->STAT = (PROP->STAT & ~PROP_STAT_CLR_MASK) | PROP_STAT_CLR(0);
}

void PROP_StopTx(PROP_Type *base)
{
    BLEDP->DP_TOP_SYSTEM_CTRL = (BLEDP->DP_TOP_SYSTEM_CTRL & ~BLEDP_DP_TOP_SYSTEM_CTRL_TX_REQ_MASK)
                                | BLEDP_DP_TOP_SYSTEM_CTRL_TX_REQ(0);
}

void PROP_StopRx(PROP_Type *base)
{
    BLEDP->DP_TOP_SYSTEM_CTRL = (BLEDP->DP_TOP_SYSTEM_CTRL & ~BLEDP_DP_TOP_SYSTEM_CTRL_RX_REQ_MASK)
                                | BLEDP_DP_TOP_SYSTEM_CTRL_RX_REQ(0);
}

void PROP_SetPayloadLen(PROP_Type *base, uint16_t payloadLen)
{
    BLEDP->DP_TOP_SYSTEM_CTRL = (BLEDP->DP_TOP_SYSTEM_CTRL & ~BLEDP_DP_TOP_SYSTEM_CTRL_RX_PDU_LEN_IN_MASK)
                                | BLEDP_DP_TOP_SYSTEM_CTRL_RX_PDU_LEN_IN(payloadLen << 3);
}

uint16_t PROP_GetPayloadLen(PROP_Type *base)
{
    return (uint16_t)((BLEDP->DP_TOP_SYSTEM_CTRL & BLEDP_DP_TOP_SYSTEM_CTRL_RX_PDU_LEN_IN_MASK) >> BLEDP_DP_TOP_SYSTEM_CTRL_RX_PDU_LEN_IN_SHIFT)>>3;
}


bool PROP_GetTxStatus(PROP_Type *base)
{
    return (BLEDP-> BLE_DP_STATUS1 & BLEDP_BLE_DP_STATUS1_TX_BUSY_MASK) ? true : false;
}


bool PROP_GetCrcStatus(PROP_Type *base)
{
    return (BLEDP-> BLE_DP_STATUS2 & BLEDP_BLE_DP_STATUS2_CRC_ERROR_MASK) ? false : true;
}

uint8_t PROP_GetRssi(PROP_Type *base)
{
    return (uint8_t)((BLEDP-> BLE_DP_STATUS1 & BLEDP_BLE_DP_STATUS1_AGC_RSSI_MASK)>> BLEDP_BLE_DP_STATUS1_AGC_RSSI_SHIFT);
}


void PROP_SetPacketConfig(PROP_Type *base, uint8_t preambelSize, uint8_t accessAddress, uint8_t bitOrder)
{
   /* Set preamble size, access address size and bitOrder to register, payload length  */
    BLEDP->PROP_MODE_CTRL = (BLEDP->PROP_MODE_CTRL & ~( BLEDP_PROP_MODE_CTRL_PROP_PRE_NUM_MASK
                                                      | BLEDP_PROP_MODE_CTRL_PROP_AA_NUM_MASK))
                            | BLEDP_PROP_MODE_CTRL_PROP_PRE_NUM(preambelSize)
                            | BLEDP_PROP_MODE_CTRL_PROP_AA_NUM(accessAddress);    
    /* Set bit order to register */
    base->STAT = (base->STAT & ~PROP_STAT_BIT_ORDER_MASK) | PROP_STAT_BIT_ORDER(bitOrder);
}

void PROP_GetPacketConfig(PROP_Type *base, uint8_t *preambelSize, uint8_t *accessAddress, uint8_t *bitOrder)
{
    *preambelSize =(uint8_t)(BLEDP->PROP_MODE_CTRL & BLEDP_PROP_MODE_CTRL_PROP_PRE_NUM_MASK) >> BLEDP_PROP_MODE_CTRL_PROP_PRE_NUM_SHIFT;
    *accessAddress = (uint8_t)(BLEDP->PROP_MODE_CTRL & BLEDP_PROP_MODE_CTRL_PROP_AA_NUM_MASK) >> BLEDP_PROP_MODE_CTRL_PROP_AA_NUM_SHIFT;
    *bitOrder = (uint8_t)(base->STAT & PROP_STAT_BIT_ORDER_MASK) >> PROP_STAT_BIT_ORDER_SHIFT;
}


void PROP_SetNetworkAddress(PROP_Type *base, uint8_t *pAccessAddress)
{
    BLEDP->ACCESS_ADDRESS = (* (uint32_t *) pAccessAddress);
    BLEDP->PROP_MODE_CTRL = (BLEDP->PROP_MODE_CTRL & ~BLEDP_PROP_MODE_CTRL_PROP_AA_ADDR_IN_MASK) | BLEDP_PROP_MODE_CTRL_PROP_AA_ADDR_IN(* ((uint8_t *)(pAccessAddress + 4)));
}

void PROP_GetNetworkAddress(PROP_Type *base, uint8_t *pAccessAddress)
{
    (* (uint32_t *) pAccessAddress) = BLEDP->ACCESS_ADDRESS;
     * ((uint8_t *)(pAccessAddress + 4)) =(uint8_t)BLEDP->PROP_MODE_CTRL;
}


void PROP_SetChannelNumber(PROP_Type *base, uint8_t channelNum, prop_radio_operation_t radioOp)
{
    uint32_t radioFreq = PROP_RADIOFREQ_BASE_2400MHZ + channelNum;
    uint32_t nLoFreq = 0;

    switch (radioOp)
    {
        case kPROP_RadioFreqTx:
            nLoFreq = (radioFreq << 20);
            break;
        case kPROP_RadioFreqRxMode2:
            nLoFreq = ((uint32_t)(((radioFreq - 2394 - 2) << 20) * 8 / 7)) + (2736LL << 20);
            break;
        case kPROP_RadioFreqRxMode1:
            nLoFreq = ((uint32_t)(((radioFreq - 2394 - 1) << 20) * 8 / 7)) + (2736LL << 20);
            break;
        default:
            break;
    }
    
    uint32_t nLoInt = ((nLoFreq >> 20) / 16) - 128;   
    uint32_t nLoFrac = (nLoFreq / 16) - (((nLoInt + 128)) << 20);
    
    CALIB->LO_CFG = (CALIB->LO_CFG & ~(CALIB_LO_CFG_LO_SEL_MASK
                                      | CALIB_LO_CFG_LO_FRAC_CFG_MASK
                                      | CALIB_LO_CFG_LO_INT_CFG_MASK))
                    | CALIB_LO_CFG_LO_SEL(1)
                    | CALIB_LO_CFG_LO_FRAC_CFG(nLoFrac)
                    | CALIB_LO_CFG_LO_INT_CFG(nLoInt);
    
    /*Calibrate power when frequency change*/
    CALIB->CTRL = (CALIB->CTRL & (~CALIB_CTRL_HOP_CLB_SEL_MASK)) | CALIB_CTRL_HOP_CLB_SEL(1);
    CALIB->INT_RAW = CALIB_INT_RAW_HOP_CAL_DONE_INT(1);
    CALIB->START = CALIB_START_HOP_CLB_START(1);

    while (!(CALIB->INT_RAW & CALIB_INT_RAW_HOP_CAL_DONE_INT_MASK));

    // clear interrupt flag
    CALIB->INT_RAW = CALIB_INT_RAW_HOP_CAL_DONE_INT(1);
}


uint8_t PROP_GetChannelNumber(PROP_Type *base, prop_radio_operation_t radioOp)
{
    //reback
    uint32_t radioFreq = 0;
    uint32_t lo_cfg;
    uint32_t nLoInt;
    uint32_t nLoFrac;
    uint32_t tmp, ceil;
  
    lo_cfg  = CALIB->LO_CFG;
    nLoInt  = (lo_cfg & CALIB_LO_CFG_LO_INT_CFG_MASK) >> CALIB_LO_CFG_LO_INT_CFG_SHIFT;
    nLoFrac = (lo_cfg & CALIB_LO_CFG_LO_FRAC_CFG_MASK) >> CALIB_LO_CFG_LO_FRAC_CFG_SHIFT;
  
    tmp = nLoFrac*14;
    ceil = (tmp & 0xFFFFF) ? 1 : 0; 
  
    switch (radioOp)
    {
        case kPROP_RadioFreqTx:
            radioFreq = (2048 + (nLoInt << 4) + (nLoFrac >> 16));
            break;
        case kPROP_RadioFreqRxMode2:
            radioFreq = (1792 + nLoInt*14 + (tmp >> 20) + ceil + 2);
            break;
        case kPROP_RadioFreqRxMode1:
            radioFreq = (1792 + nLoInt*14 + (tmp >> 20) + ceil + 1);
            break;
        default:
            break;
    }
    
    return (uint8_t)(radioFreq - PROP_RADIOFREQ_BASE_2400MHZ);
}


void PROP_SetCrcConfig(PROP_Type *base, uint8_t crcSize, uint8_t crcStartByte, uint32_t crcSeed)
{
     BLEDP->PROP_MODE_CTRL = (BLEDP->PROP_MODE_CTRL & ~BLEDP_PROP_MODE_CTRL_PROP_CRC_NUM_MASK)|BLEDP_PROP_MODE_CTRL_PROP_CRC_NUM(crcSize);    
     BLEDP->DF_ANTENNA_CTRL = (BLEDP->DF_ANTENNA_CTRL & ~BLEDP_DF_ANTENNA_CTRL_PROP_CRC_AA_DIS_MASK)|BLEDP_DF_ANTENNA_CTRL_PROP_CRC_AA_DIS(crcStartByte);  
     BLEDP->CRCSEED = BLEDP_CRCSEED_CRC_SEED_IN(crcSeed)|BLEDP_CRCSEED_CRC_SEED_WEN(1);
}

void PROP_GetCrcConfig(PROP_Type *base, uint8_t *crcSize, uint8_t *crcStartByte, uint32_t *crcSeed)
{
     *crcSize = (BLEDP->PROP_MODE_CTRL & BLEDP_PROP_MODE_CTRL_PROP_CRC_NUM_MASK) >> BLEDP_PROP_MODE_CTRL_PROP_CRC_NUM_SHIFT;
     *crcStartByte = (BLEDP->DF_ANTENNA_CTRL & BLEDP_DF_ANTENNA_CTRL_PROP_CRC_AA_DIS_MASK) >> BLEDP_DF_ANTENNA_CTRL_PROP_CRC_AA_DIS_SHIFT;
     *crcSeed = (BLEDP->CRCSEED & BLEDP_CRCSEED_CRC_SEED_IN_MASK) >> BLEDP_CRCSEED_CRC_SEED_IN_SHIFT;
}

void PROP_RadioConfig(PROP_Type *base, prop_radio_mode_t radioMode, prop_data_rate_t dataRate)
{
    uint32_t setDataRate = 0;
  
   /* setting for different data rate */
    if (dataRate == kPROP_DataRate2MBit)
    {
        BLEDP->DF_ANTENNA_CTRL = (BLEDP_DF_ANTENNA_CTRL_PHY_RATE_REG(1) | BLEDP_DF_ANTENNA_CTRL_PHY_RATE_WEN(1));
    }
    else if (dataRate == kPROP_DataRate500KBit || dataRate == kPROP_DataRate250KBit)
    {
        BLEDP->FREQ_DOMAIN_CTRL1 = (BLEDP->FREQ_DOMAIN_CTRL1 & ~BLEDP_FREQ_DOMAIN_CTRL1_RD_EXBIT_EN_MASK) 
                                   | BLEDP_FREQ_DOMAIN_CTRL1_RD_EXBIT_EN(0);
        
        setDataRate = (dataRate == kPROP_DataRate500KBit)? 1 : 3; 
    }
    else ;
    
    /*Set Datarate 2M/1M set_datarate =0; 500k:1, 250k:3 */  
    BLEDP->PROP_MODE_CTRL = (BLEDP->PROP_MODE_CTRL & ~BLEDP_PROP_MODE_CTRL_PROP_DATA_RATE_MASK)|BLEDP_PROP_MODE_CTRL_PROP_DATA_RATE(setDataRate);
    
    /* Set the radio mode  */
    BLEDP->DP_TOP_SYSTEM_CTRL = (BLEDP->DP_TOP_SYSTEM_CTRL & ~BLEDP_DP_TOP_SYSTEM_CTRL_H_IDX_MASK)|BLEDP_DP_TOP_SYSTEM_CTRL_H_IDX(radioMode);
}


void PROP_ModTx(PROP_Type *base,prop_modem_mode_t mode,prop_pattern_type_t payload_type)
{
    // Payload
    if(payload_type == kPROP_PatternType6)
    {
        BLEDP->ANT_PDU_DATA0 = BLEDP_ANT_PDU_DATA0_PROP_PREAMBLE(0x55)| BLEDP_ANT_PDU_DATA0_PATTERN_SEL(6);
    }
    else
    {
        BLEDP->ANT_PDU_DATA0 = BLEDP_ANT_PDU_DATA0_PROP_PREAMBLE(0x55) |BLEDP_ANT_PDU_DATA0_TEST_PATTERN_EN(1)| BLEDP_ANT_PDU_DATA0_PATTERN_SEL(payload_type);
    }

    // bit[30] start repetitious transmit using tx_req
    BLEDP->DP_FUNCTION_CTRL = (BLEDP->DP_FUNCTION_CTRL |BLEDP_DP_FUNCTION_CTRL_TX_EN_MODE(1));
    // bit[26] tx always on, bit[18:16] porp mode preamble number
    BLEDP->PROP_MODE_CTRL = (BLEDP->PROP_MODE_CTRL & ~BLEDP_PROP_MODE_CTRL_TX_ALWAYS_ON_MASK)|BLEDP_PROP_MODE_CTRL_TX_ALWAYS_ON(1);
    
    if(mode == kPROP_UnModulation)
    { 
        BLEDP->DP_TEST_CTRL |= BLEDP_DP_TEST_CTRL_DAC_TEST(0x8)|BLEDP_DP_TEST_CTRL_DAC_TEST_EN(1);
    }
    else
    {
         BLEDP->DP_TEST_CTRL &=BLEDP_DP_TEST_CTRL_TIF_SEL_MASK |BLEDP_DP_TEST_CTRL_TIF_CLK_SEL_MASK
                           | BLEDP_DP_TEST_CTRL_CORDIC_DAC_OUT_MASK|BLEDP_DP_TEST_CTRL_TIF_EN_MASK
                             |BLEDP_DP_TEST_CTRL_IMR_INV_MASK|BLEDP_DP_TEST_CTRL_CLK_TX_GATE_DIS_MASK |BLEDP_DP_TEST_CTRL_BUF_FULL_OFFRF_DIS_MASK;
   
    }

    BLEDP->DP_TOP_SYSTEM_CTRL = (BLEDP->DP_TOP_SYSTEM_CTRL&~BLEDP_DP_TOP_SYSTEM_CTRL_ANT_DATA_START_MASK);
    BLEDP->DP_TOP_SYSTEM_CTRL |= (BLEDP_DP_TOP_SYSTEM_CTRL_ANT_DATA_START(1) |BLEDP_DP_TOP_SYSTEM_CTRL_TX_REQ(1)|BLEDP_DP_TOP_SYSTEM_CTRL_TX_EN_SEL(1));
}
void PROP_ModIdle(PROP_Type *base)
{
   
    BLEDP->ANT_PDU_DATA0 = BLEDP_ANT_PDU_DATA0_PROP_PREAMBLE(0x55);
    BLEDP->DP_TOP_SYSTEM_CTRL = (BLEDP->DP_TOP_SYSTEM_CTRL & ~BLEDP_DP_TOP_SYSTEM_CTRL_RX_REQ_MASK)
                                | BLEDP_DP_TOP_SYSTEM_CTRL_RX_REQ(0);
    BLEDP->DP_TOP_SYSTEM_CTRL = (BLEDP->DP_TOP_SYSTEM_CTRL & ~BLEDP_DP_TOP_SYSTEM_CTRL_TX_REQ_MASK)
                                | BLEDP_DP_TOP_SYSTEM_CTRL_TX_REQ(0);
    BLEDP->PROP_MODE_CTRL = (BLEDP->PROP_MODE_CTRL & ~BLEDP_PROP_MODE_CTRL_TX_ALWAYS_ON_MASK);
    BLEDP->DP_TEST_CTRL &=BLEDP_DP_TEST_CTRL_TIF_SEL_MASK |BLEDP_DP_TEST_CTRL_TIF_CLK_SEL_MASK
                           | BLEDP_DP_TEST_CTRL_CORDIC_DAC_OUT_MASK|BLEDP_DP_TEST_CTRL_TIF_EN_MASK
                             |BLEDP_DP_TEST_CTRL_IMR_INV_MASK|BLEDP_DP_TEST_CTRL_CLK_TX_GATE_DIS_MASK |BLEDP_DP_TEST_CTRL_BUF_FULL_OFFRF_DIS_MASK;
   
}

void PROP_ModRx(PROP_Type *base)
{
    // bit[31] start repetitious receiving using rx_req
    BLEDP->DP_FUNCTION_CTRL = (BLEDP->DP_FUNCTION_CTRL |BLEDP_DP_FUNCTION_CTRL_RX_EN_MODE(1));
                
    // bit[25] rx always on, bit[18:16] porp mode preamble number
    BLEDP->PROP_MODE_CTRL = (BLEDP->PROP_MODE_CTRL & ~BLEDP_PROP_MODE_CTRL_TX_ALWAYS_ON_MASK)|BLEDP_PROP_MODE_CTRL_RX_ALWAYS_ON(1);
               
    BLEDP->DP_TOP_SYSTEM_CTRL = (BLEDP->DP_TOP_SYSTEM_CTRL&~BLEDP_DP_TOP_SYSTEM_CTRL_ANT_DATA_START_MASK);
    BLEDP->DP_TOP_SYSTEM_CTRL |= (BLEDP_DP_TOP_SYSTEM_CTRL_ANT_DATA_START(1) |BLEDP_DP_TOP_SYSTEM_CTRL_RX_REQ(1)|BLEDP_DP_TOP_SYSTEM_CTRL_RX_EN_SEL(1));

}




