/*******************************************************************************
* NXP Semiconductors
* ALL RIGHTS RESERVED.
********************************************************************************
Services performed by NXP in this matter are performed AS IS and without 
any warranty. CUSTOMER retains the final decision relative to the total design 
and functionality of the end product. NXP neither guarantees nor will be 
held liable by CUSTOMER for the success of this project.
NXP DISCLAIMS ALL WARRANTIES, EXPRESSED, IMPLIED OR STATUTORY INCLUDING, 
BUT NOT LIMITED TO, IMPLIED WARRANTY OF MERCHANTABILITY OR FITNESS FOR 
A PARTICULAR PURPOSE ON ANY HARDWARE, SOFTWARE OR ADVISE SUPPLIED TO THE PROJECT
BY NXP, AND OR NAY PRODUCT RESULTING FROM NXP SERVICES. IN NO EVENT
SHALL NXP BE LIABLE FOR INCIDENTAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF
THIS AGREEMENT.

CUSTOMER agrees to hold NXP harmless against any and all claims demands or
actions by anyone on account of any damage, or injury, whether commercial, 
contractual, or tortuous, rising directly or indirectly as a result of an advise
or assistance supplied CUSTOMER in connection with product, services or goods 
supplied under this Agreement.
********************************************************************************
* File      main.c
* Owner     NXA19261
* Version   1.0
* Date      Aug-17-2017
* Classification   General Business Information
* Brief     Error functions
********************************************************************************
* Detailed Description:
* Error functions.
* 
********************************************************************************
Revision History:
Version  Date         Author    Description of Changes
1.0      Aug-17-2017  NXA19261  Initial version
*******************************************************************************/
#include <string.h>
#include "Errors.h"
#include "Config.h"

#if BOOTLODER_REWRITABLE 
static char * ErrorString[] = {
#else
static char * const ErrorString[] = {		
#endif /* BOOTLODER_REWRITABLE */

                                      NULL,
                                      "S-Record Out Of Range",
                                      "S-Record Size Must Be Even",
                                      "Programming Error",
                                      "Erase Error",
                                      "Bad Data",
                                      "S-Record Too Long",
                                      "CheckSumErr",
                                    };


#if BOOTLODER_REWRITABLE 
char BadError[] = "Invalid Error Number";
#else
const char BadError[] = "Invalid Error Number";		
#endif /* BOOTLODER_REWRITABLE */

/*******************************************************************************
 Function Name : GetErrorString
 Engineer      : NXA19261
 Date          : Aug-17-2017
 Parameters    : Error Number 
 Modifies      : NONE
 Returns       : pointer to the Error String
 Notes         : Return pointer to the Error String with error description.
 Issues        : NONE
 *******************************************************************************/
#if BOOTLODER_REWRITABLE 
#pragma CODE_SEG DEFAULT_RAM
#endif /* BOOTLODER_REWRITABLE */
char * GetErrorString(char ErrorNumber)
{
  int MaxError;
  
  MaxError = sizeof(ErrorString) / sizeof(char *);
  
  if (ErrorNumber > MaxError)
    return((char * const)BadError);
  else
    return(ErrorString[ErrorNumber]);
 
}
#if BOOTLODER_REWRITABLE 
#pragma CODE_SEG DEFAULT
#endif /* BOOTLODER_REWRITABLE */
/******************************************************************************/
