/*******************************************************************************
* NXP Semiconductors
* ALL RIGHTS RESERVED.
********************************************************************************
Services performed by NXP in this matter are performed AS IS and without 
any warranty. CUSTOMER retains the final decision relative to the total design 
and functionality of the end product. NXP neither guarantees nor will be 
held liable by CUSTOMER for the success of this project.
NXP DISCLAIMS ALL WARRANTIES, EXPRESSED, IMPLIED OR STATUTORY INCLUDING, 
BUT NOT LIMITED TO, IMPLIED WARRANTY OF MERCHANTABILITY OR FITNESS FOR 
A PARTICULAR PURPOSE ON ANY HARDWARE, SOFTWARE OR ADVISE SUPPLIED TO THE PROJECT
BY NXP, AND OR NAY PRODUCT RESULTING FROM NXP SERVICES. IN NO EVENT
SHALL NXP BE LIABLE FOR INCIDENTAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF
THIS AGREEMENT.

CUSTOMER agrees to hold NXP harmless against any and all claims demands or
actions by anyone on account of any damage, or injury, whether commercial, 
contractual, or tortuous, rising directly or indirectly as a result of an advise
or assistance supplied CUSTOMER in connection with product, services or goods 
supplied under this Agreement.
********************************************************************************
* File      main.c
* Owner     NXA19261
* Version   1.0
* Date      Aug-17-2017
* Classification   General Business Information
* Brief     S12Z Bootloader configuration header file. 
********************************************************************************
* Detailed Description:
* S12Z Bootloader configuration header file.
* 
********************************************************************************
Revision History:
Version  Date         Author    Description of Changes
1.0      Aug-17-2017  NXA19261  Initial version
*******************************************************************************/

#ifndef CONFIG_H_
#define CONFIG_H_

//==============================================================================
// Configure Bootloader features
//============================================================================== 
#define SECURE_MCU           0
#define USE_BACKDOOR_KEY     0
#define WRITE_EEPROM         1
//The BOOTLODER_REWRITABLE is already defined in Build Configuration
//That way we use two linker files and use one per selected Build Configuration.
//#define BOOTLODER_REWRITABLE 0 //for FLASH-P (Persistent Bootloader code) 
//#define BOOTLODER_REWRITABLE 1 //for FLASH-R (Rewritable Bootloader code)


//==============================================================================
// Configure Clocks
//==============================================================================
//Configure bus clock to the 25MHz in PEI mode (1MHz IRCCLK as source clock).
//The 25MHz is the smallest maximum bus clock for S12Z derivatives and it allows access Flash without wait states (assumed Tj<150C)
#define BL_SYNR              0x58 //CPMUSYNR
#define BL_REFDV             0x00 //CPMUREFDIV
#define BL_POSDIV            0x00 //CPMUPOSTDIV

#define BL_FCLKDIV           24   //Flash Clock Divider for 25MHz bus clock

//==============================================================================
// Configure Serial Channel
//============================================================================== 
#define SCI_MODULE         SCI1
#define DEFAULT_BAUDRATE   Baud9600
#define BL_MODRR0          0x08  //MODRR0_SCI1RR=1 TXD1 on PT5; RXD1 on PT4 for S12ZVL
                                 //                TXD1 on PS3; RXD1 on PS2 for S12ZVM

//==============================================================================
// Bootloader request definition - Push Button, EEPROM value
//==============================================================================
#define PUSH_BOTTON        PTP_PTP4   //SW2 button at DEVKIT-ZVL128(DEVKIT-S12ZVL) board
#define PB_ACTIVE_LEVEL    1
//#define PUSH_BOTTON        PTP_PTP1   //"UP" button at S12ZVMC256EVB, S12ZVM32EVB, S12ZVMC12EVBCAN, S12ZVMC12EVBLIN boards
//#define PB_ACTIVE_LEVEL    0

#define BL_REQUEST_ADD     0x100000   //Address for Bootloader request 
#define BL_REQUEST_VALUE   0x424F4F54 //Bootloader request key value "BOOT" in ASCII = 0x424F4F54

//==============================================================================
// Configure Derivative
//============================================================================== 
//Please select your derivative 
//#define FLASH_START_ADD 0xFC0000UL //for 256kB derivatives
//#define FLASH_START_ADD 0xFD0000UL //for 192kB derivatives
#define FLASH_START_ADD 0xFE0000UL //for 128kB derivatives
//#define FLASH_START_ADD 0xFE8000UL //for 96kB derivatives
//#define FLASH_START_ADD 0xFF0000UL //for 64kB derivatives
//#define FLASH_START_ADD 0xFF8000UL //for 32kB derivatives
//#define FLASH_START_ADD 0xFFD000UL //for 16kB derivatives
//#define FLASH_START_ADD 0xFFE000UL //for 8kB derivatives

#define EEPROM_START_ADD                  0x100000 //EEPROM start address
#define EEPROM_END_ADD                    0x10007F //EEPROM end address

//==============================================================================
// P-Flash Addresses
//==============================================================================
//Please configure Bootloader area in *.prm linker file

extern int __SEG_START__PRESTART[];

#define BOOTLOADER_START_ADD              ((unsigned long)__SEG_START__PRESTART) //Bootloader start address defined by Bootloader linker file (ROM segment).
#define BOOTLOADER_END_ADD                0xFFFFFF
#define BOOTLOADER_SIZE                   (BOOTLOADER_END_ADD-BOOTLOADER_START_ADD)

#define APPLICATION_RESET_VEC_SRC         0xFFFFE0                  //last 32bytes in Flash with reset vector. Reset vector starts at 0xFFFFFD
#define APPLICATION_END_ADD               (BOOTLOADER_START_ADD-4)  //last four bytes from Application are allocated for Application Reset Vector
#define APPLICATION_RESET_VEC_ADD         APPLICATION_END_ADD       //here is stored reset vector of user application

//==============================================================================
// Configure Flash Configuration Field
//============================================================================== 
//Backdoor Comparison Key  "UNSECURE" in ASCII = 0x554E534543555245
#define BACKDOOR_KEY_0 0x55
#define BACKDOOR_KEY_1 0x4E
#define BACKDOOR_KEY_2 0x53
#define BACKDOOR_KEY_3 0x45
#define BACKDOOR_KEY_4 0x43
#define BACKDOOR_KEY_5 0x55
#define BACKDOOR_KEY_6 0x52
#define BACKDOOR_KEY_7 0x45

//Protection Override Comparison Key "AB" in ASCII = 0x4142
#define PROTECTION_OVERRIDE_KEY_H 0x41
#define PROTECTION_OVERRIDE_KEY_L 0x42

//Please select Bootloader area which will be protected
//#define BL_FPROT  0xDF       //upper 16kB of P-Flash protected.
#define BL_FPROT  0xD7       //upper 8kB of P-Flash protected.
//#define BL_FPROT  0xCF       //upper 4kB of P-Flash protected.
//#define BL_FPROT  0xFF       //unprotected.

#define BL_DFPROT 0xFF       //EEPROM unprotected.

#define BL_FOPT   0xFF       //COP is not active after reset.



#endif /* CONFIG_H_ */
